/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.angus.mail.util.LineInputStream;
import org.eclipse.angus.mail.util.MailLogger;
import org.eclipse.angus.mail.util.MailSSLSocketFactory;
import org.eclipse.angus.mail.util.PropUtil;
import org.eclipse.angus.mail.util.SocketConnectException;
import org.eclipse.angus.mail.util.WriteTimeoutSocket;

public class SocketFetcher {
    private static MailLogger logger = new MailLogger(SocketFetcher.class, "socket", "DEBUG SocketFetcher", PropUtil.getBooleanSystemProperty("mail.socket.debug", false), System.out);

    private SocketFetcher() {
    }

    public static Socket getSocket(String host, int port, Properties props, String prefix, boolean useSSL) throws IOException {
        int to;
        int localport;
        InetAddress localaddr;
        Socket socket;
        int cto;
        block21: {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("getSocket, host " + host + ", port " + port + ", prefix " + prefix + ", useSSL " + useSSL);
            }
            if (prefix == null) {
                prefix = "socket";
            }
            if (props == null) {
                props = new Properties();
            }
            cto = PropUtil.getIntProperty(props, prefix + ".connectiontimeout", -1);
            socket = null;
            String localaddrstr = props.getProperty(prefix + ".localaddress", null);
            localaddr = null;
            if (localaddrstr != null) {
                localaddr = InetAddress.getByName(localaddrstr);
            }
            localport = PropUtil.getIntProperty(props, prefix + ".localport", 0);
            boolean fb = PropUtil.getBooleanProperty(props, prefix + ".socketFactory.fallback", true);
            int sfPort = -1;
            String sfErr = "unknown socket factory";
            to = PropUtil.getIntProperty(props, prefix + ".timeout", -1);
            try {
                String sfClass;
                Object sfo;
                SocketFactory sf = null;
                String sfPortName = null;
                if (useSSL) {
                    sfo = props.get(prefix + ".ssl.socketFactory");
                    if (sfo instanceof SocketFactory) {
                        sf = (SocketFactory)sfo;
                        sfErr = "SSL socket factory instance " + sf;
                    }
                    if (sf == null) {
                        sfClass = props.getProperty(prefix + ".ssl.socketFactory.class");
                        sf = SocketFetcher.getSocketFactory(sfClass);
                        sfErr = "SSL socket factory class " + sfClass;
                    }
                    sfPortName = ".ssl.socketFactory.port";
                }
                if (sf == null) {
                    sfo = props.get(prefix + ".socketFactory");
                    if (sfo instanceof SocketFactory) {
                        sf = (SocketFactory)sfo;
                        sfErr = "socket factory instance " + sf;
                    }
                    if (sf == null) {
                        sfClass = props.getProperty(prefix + ".socketFactory.class");
                        sf = SocketFetcher.getSocketFactory(sfClass);
                        sfErr = "socket factory class " + sfClass;
                    }
                    sfPortName = ".socketFactory.port";
                }
                if (sf != null) {
                    sfPort = PropUtil.getIntProperty(props, prefix + sfPortName, -1);
                    if (sfPort == -1) {
                        sfPort = port;
                    }
                    socket = SocketFetcher.createSocket(localaddr, localport, host, sfPort, cto, to, props, prefix, sf, useSSL);
                }
            }
            catch (SocketTimeoutException sex) {
                throw sex;
            }
            catch (Exception ex) {
                Throwable t2;
                if (fb) break block21;
                if (ex instanceof InvocationTargetException && (t2 = ((InvocationTargetException)ex).getTargetException()) instanceof Exception) {
                    ex = (Exception)t2;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw new SocketConnectException("Using " + sfErr, ex, host, sfPort, cto);
            }
        }
        if (socket == null) {
            socket = SocketFetcher.createSocket(localaddr, localport, host, port, cto, to, props, prefix, null, useSSL);
        } else if (to >= 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("set socket read timeout " + to);
            }
            socket.setSoTimeout(to);
        }
        return socket;
    }

    public static Socket getSocket(String host, int port, Properties props, String prefix) throws IOException {
        return SocketFetcher.getSocket(host, port, props, prefix, false);
    }

    private static Socket createSocket(InetAddress localaddr, int localport, String host, int port, int cto, int to, Properties props, String prefix, SocketFactory sf, boolean useSSL) throws IOException {
        int writeTimeout;
        int i;
        Socket socket = null;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("create socket: prefix " + prefix + ", localaddr " + localaddr + ", localport " + localport + ", host " + host + ", port " + port + ", connection timeout " + cto + ", timeout " + to + ", socket factory " + sf + ", useSSL " + useSSL);
        }
        String proxyHost = props.getProperty(prefix + ".proxy.host", null);
        String proxyUser = props.getProperty(prefix + ".proxy.user", null);
        String proxyPassword = props.getProperty(prefix + ".proxy.password", null);
        int proxyPort = 80;
        String socksHost = null;
        int socksPort = 1080;
        String err = null;
        if (proxyHost != null) {
            i = proxyHost.indexOf(58);
            if (i >= 0) {
                try {
                    proxyPort = Integer.parseInt(proxyHost.substring(i + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                proxyHost = proxyHost.substring(0, i);
            }
            proxyPort = PropUtil.getIntProperty(props, prefix + ".proxy.port", proxyPort);
            err = "Using web proxy host, port: " + proxyHost + ", " + proxyPort;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("web proxy host " + proxyHost + ", port " + proxyPort);
                if (proxyUser != null) {
                    logger.finer("web proxy user " + proxyUser + ", password " + (proxyPassword == null ? "<null>" : "<non-null>"));
                }
            }
        } else {
            socksHost = props.getProperty(prefix + ".socks.host", null);
            if (socksHost != null) {
                i = socksHost.indexOf(58);
                if (i >= 0) {
                    try {
                        socksPort = Integer.parseInt(socksHost.substring(i + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    socksHost = socksHost.substring(0, i);
                }
                socksPort = PropUtil.getIntProperty(props, prefix + ".socks.port", socksPort);
                err = "Using SOCKS host, port: " + socksHost + ", " + socksPort;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("socks host " + socksHost + ", port " + socksPort);
                }
            }
        }
        if (sf != null && !(sf instanceof SSLSocketFactory)) {
            socket = sf.createSocket();
        }
        if (socket == null) {
            if (socksHost != null) {
                socket = new Socket(new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(socksHost, socksPort)));
            } else if (PropUtil.getBooleanProperty(props, prefix + ".usesocketchannels", false)) {
                logger.finer("using SocketChannels");
                socket = SocketChannel.open().socket();
            } else {
                socket = new Socket();
            }
        }
        if (to >= 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("set socket read timeout " + to);
            }
            socket.setSoTimeout(to);
        }
        if ((writeTimeout = PropUtil.getIntProperty(props, prefix + ".writetimeout", -1)) != -1) {
            ScheduledExecutorService executorService;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("set socket write timeout " + writeTimeout);
            }
            Socket socket2 = socket = (executorService = PropUtil.getScheduledExecutorServiceProperty(props, prefix + ".executor.writetimeout")) == null ? new WriteTimeoutSocket(socket, writeTimeout) : new WriteTimeoutSocket(socket, writeTimeout, executorService);
        }
        if (localaddr != null) {
            socket.bind(new InetSocketAddress(localaddr, localport));
        }
        try {
            logger.finest("connecting...");
            if (proxyHost != null) {
                SocketFetcher.proxyConnect(socket, proxyHost, proxyPort, proxyUser, proxyPassword, host, port, cto);
            } else if (cto >= 0) {
                socket.connect(new InetSocketAddress(host, port), cto);
            } else {
                socket.connect(new InetSocketAddress(host, port));
            }
            logger.finest("success!");
        }
        catch (IOException ex) {
            logger.log(Level.FINEST, "connection failed", ex);
            throw new SocketConnectException(err, ex, host, port, cto);
        }
        if ((useSSL || sf instanceof SSLSocketFactory) && !(socket instanceof SSLSocket)) {
            SSLSocketFactory ssf;
            String trusted = props.getProperty(prefix + ".ssl.trust");
            if (trusted != null) {
                try {
                    MailSSLSocketFactory msf = new MailSSLSocketFactory();
                    if (trusted.equals("*")) {
                        msf.setTrustAllHosts(true);
                    } else {
                        msf.setTrustedHosts(trusted.split("\\s+"));
                    }
                    ssf = msf;
                }
                catch (GeneralSecurityException gex) {
                    IOException ioex = new IOException("Can't create MailSSLSocketFactory");
                    ioex.initCause(gex);
                    throw ioex;
                }
            } else {
                ssf = sf instanceof SSLSocketFactory ? (SSLSocketFactory)sf : (SSLSocketFactory)SSLSocketFactory.getDefault();
            }
            socket = ssf.createSocket(socket, host, port, true);
            sf = ssf;
        }
        SocketFetcher.configureSSLSocket(socket, host, props, prefix, sf);
        return socket;
    }

    private static SocketFactory getSocketFactory(String sfClass) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (sfClass == null || sfClass.length() == 0) {
            return null;
        }
        ClassLoader cl = SocketFetcher.getContextClassLoader();
        Class<?> clsSockFact = null;
        if (cl != null) {
            try {
                clsSockFact = Class.forName(sfClass, false, cl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clsSockFact == null) {
            clsSockFact = Class.forName(sfClass);
        }
        Method mthGetDefault = clsSockFact.getMethod("getDefault", new Class[0]);
        SocketFactory sf = (SocketFactory)mthGetDefault.invoke(new Object(), new Object[0]);
        return sf;
    }

    @Deprecated
    public static Socket startTLS(Socket socket) throws IOException {
        return SocketFetcher.startTLS(socket, new Properties(), "socket");
    }

    @Deprecated
    public static Socket startTLS(Socket socket, Properties props, String prefix) throws IOException {
        InetAddress a = socket.getInetAddress();
        String host = a.getHostName();
        return SocketFetcher.startTLS(socket, host, props, prefix);
    }

    public static Socket startTLS(Socket socket, String host, Properties props, String prefix) throws IOException {
        int port = socket.getPort();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("startTLS host " + host + ", port " + port);
        }
        String sfErr = "unknown socket factory";
        try {
            String sfClass;
            SSLSocketFactory ssf = null;
            SocketFactory sf = null;
            Object sfo = props.get(prefix + ".ssl.socketFactory");
            if (sfo instanceof SocketFactory) {
                sf = (SocketFactory)sfo;
                sfErr = "SSL socket factory instance " + sf;
            }
            if (sf == null) {
                sfClass = props.getProperty(prefix + ".ssl.socketFactory.class");
                sf = SocketFetcher.getSocketFactory(sfClass);
                sfErr = "SSL socket factory class " + sfClass;
            }
            if (sf != null && sf instanceof SSLSocketFactory) {
                ssf = (SSLSocketFactory)sf;
            }
            if (ssf == null) {
                sfo = props.get(prefix + ".socketFactory");
                if (sfo instanceof SocketFactory) {
                    sf = (SocketFactory)sfo;
                    sfErr = "socket factory instance " + sf;
                }
                if (sf == null) {
                    sfClass = props.getProperty(prefix + ".socketFactory.class");
                    sf = SocketFetcher.getSocketFactory(sfClass);
                    sfErr = "socket factory class " + sfClass;
                }
                if (sf != null && sf instanceof SSLSocketFactory) {
                    ssf = (SSLSocketFactory)sf;
                }
            }
            if (ssf == null) {
                String trusted = props.getProperty(prefix + ".ssl.trust");
                if (trusted != null) {
                    try {
                        MailSSLSocketFactory msf = new MailSSLSocketFactory();
                        if (trusted.equals("*")) {
                            msf.setTrustAllHosts(true);
                        } else {
                            msf.setTrustedHosts(trusted.split("\\s+"));
                        }
                        ssf = msf;
                        sfErr = "mail SSL socket factory";
                    }
                    catch (GeneralSecurityException gex) {
                        IOException ioex = new IOException("Can't create MailSSLSocketFactory");
                        ioex.initCause(gex);
                        throw ioex;
                    }
                } else {
                    ssf = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    sfErr = "default SSL socket factory";
                }
            }
            socket = ssf.createSocket(socket, host, port, true);
            SocketFetcher.configureSSLSocket(socket, host, props, prefix, ssf);
        }
        catch (Exception ex) {
            Throwable t2;
            if (ex instanceof InvocationTargetException && (t2 = ((InvocationTargetException)ex).getTargetException()) instanceof Exception) {
                ex = (Exception)t2;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            IOException ioex = new IOException("Exception in startTLS using " + sfErr + ": host, port: " + host + ", " + port + "; Exception: " + ex);
            ioex.initCause(ex);
            throw ioex;
        }
        return socket;
    }

    private static void configureSSLSocket(Socket socket, String host, Properties props, String prefix, SocketFactory sf) throws IOException {
        MailSSLSocketFactory msf;
        if (!(socket instanceof SSLSocket)) {
            return;
        }
        SSLSocket sslsocket = (SSLSocket)socket;
        String protocols = props.getProperty(prefix + ".ssl.protocols", null);
        if (protocols != null) {
            sslsocket.setEnabledProtocols(SocketFetcher.stringArray(protocols));
        } else {
            String[] prots = sslsocket.getEnabledProtocols();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("SSL enabled protocols before " + Arrays.asList(prots));
            }
            ArrayList<String> eprots = new ArrayList<String>();
            for (int i = 0; i < prots.length; ++i) {
                if (prots[i] == null || prots[i].startsWith("SSL")) continue;
                eprots.add(prots[i]);
            }
            sslsocket.setEnabledProtocols(eprots.toArray(new String[0]));
        }
        String ciphers = props.getProperty(prefix + ".ssl.ciphersuites", null);
        if (ciphers != null) {
            sslsocket.setEnabledCipherSuites(SocketFetcher.stringArray(ciphers));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("SSL enabled protocols after " + Arrays.asList(sslsocket.getEnabledProtocols()));
            logger.finer("SSL enabled ciphers after " + Arrays.asList(sslsocket.getEnabledCipherSuites()));
        }
        try {
            String eia = PropUtil.getBooleanProperty(props, prefix + ".ssl.checkserveridentity", true) ? "LDAPS" : (String)null;
            SSLParameters params = sslsocket.getSSLParameters();
            params.setEndpointIdentificationAlgorithm(eia);
            sslsocket.setSSLParameters(params);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Using endpoint identification algorithm {0} with SNIs {1} for: {2}", eia, Objects.toString(params.getServerNames()), host);
            }
        }
        catch (RuntimeException re) {
            throw SocketFetcher.cleanupAndThrow(sslsocket, new IOException("Unable to set endpoint identification algorithm for: " + host, re));
        }
        try {
            sslsocket.startHandshake();
        }
        catch (IOException ioe) {
            throw SocketFetcher.cleanupAndThrow(sslsocket, ioe);
        }
        try {
            SocketFetcher.checkServerIdentity(SocketFetcher.getHostnameVerifier(props, prefix), host, sslsocket);
        }
        catch (IOException | LinkageError | ReflectiveOperationException | RuntimeException re) {
            throw SocketFetcher.cleanupAndThrow(sslsocket, new IOException("Unable to check server identity for: " + host, re));
        }
        if (sf instanceof MailSSLSocketFactory && !(msf = (MailSSLSocketFactory)sf).isServerTrusted(host, sslsocket)) {
            throw SocketFetcher.cleanupAndThrow(sslsocket, new IOException("Server is not trusted: " + host));
        }
    }

    private static IOException cleanupAndThrow(Socket socket, IOException ife) {
        try {
            socket.close();
        }
        catch (Throwable thr) {
            if (SocketFetcher.isRecoverable(thr)) {
                ife.addSuppressed(thr);
            }
            thr.addSuppressed(ife);
            if (thr instanceof Error) {
                throw (Error)thr;
            }
            if (thr instanceof RuntimeException) {
                throw (RuntimeException)thr;
            }
            throw new RuntimeException("unexpected exception", thr);
        }
        return ife;
    }

    private static boolean isRecoverable(Throwable t2) {
        return t2 instanceof Exception || t2 instanceof LinkageError;
    }

    private static void checkServerIdentity(HostnameVerifier hnv, String server, SSLSocket sslSocket) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Using HostnameVerifier {0} with {1}, {2}", Objects.toString(hnv), server, Objects.toString(sslSocket));
        }
        if (hnv == null) {
            return;
        }
        if (!hnv.verify(server, sslSocket.getSession())) {
            throw new SSLException("Server identity does not match authentication scheme: " + hnv + " DENY");
        }
    }

    private static X509Certificate getX509Certificate(Certificate[] certChain) throws IOException {
        if (certChain == null || certChain.length == 0) {
            throw new SSLPeerUnverifiedException(Arrays.toString(certChain));
        }
        Certificate first = certChain[0];
        if (first instanceof X509Certificate) {
            return (X509Certificate)first;
        }
        throw new SSLPeerUnverifiedException(first == null ? "null" : first.getClass().getName() + " " + first.getType());
    }

    private static HostnameVerifier getHostnameVerifier(Properties props, String prefix) throws ReflectiveOperationException {
        HostnameVerifier hvn = (HostnameVerifier)props.get(prefix + ".ssl.hostnameverifier");
        if (hvn != null) {
            return hvn;
        }
        String fqcn = props.getProperty(prefix + ".ssl.hostnameverifier.class");
        if (fqcn == null || fqcn.isEmpty()) {
            return null;
        }
        if ("legacy".equals(fqcn)) {
            return JdkHostnameChecker.ofFailover(MailHostnameVerifier.of());
        }
        if ("sun.security.util.HostnameChecker".equals(fqcn) || JdkHostnameChecker.class.getSimpleName().equals(fqcn)) {
            return JdkHostnameChecker.of();
        }
        if (MailHostnameVerifier.class.getSimpleName().equals(fqcn)) {
            return MailHostnameVerifier.of();
        }
        if (fqcn.indexOf(46) < 0) {
            throw new ClassNotFoundException(fqcn);
        }
        Class<HostnameVerifier> verifierClass = null;
        ClassLoader ccl = SocketFetcher.getContextClassLoader();
        if (ccl != null) {
            try {
                verifierClass = Class.forName(fqcn, false, ccl).asSubclass(HostnameVerifier.class);
            }
            catch (ClassNotFoundException | RuntimeException cnfe) {
                logger.log(Level.FINER, "Context class loader could not find: " + fqcn, cnfe);
            }
        }
        if (verifierClass == null) {
            try {
                verifierClass = Class.forName(fqcn).asSubclass(HostnameVerifier.class);
            }
            catch (ClassNotFoundException | RuntimeException cnfe) {
                logger.log(Level.FINER, "Calling class loader could not find: " + fqcn, cnfe);
            }
        }
        if (verifierClass == null) {
            try {
                verifierClass = Class.forName(fqcn, false, ClassLoader.getSystemClassLoader()).asSubclass(HostnameVerifier.class);
            }
            catch (ClassNotFoundException | RuntimeException cnfe) {
                logger.log(Level.FINER, "System class loader could not find: " + fqcn, cnfe);
            }
        }
        if (verifierClass != null) {
            return verifierClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        verifierClass = Class.forName(fqcn).asSubclass(HostnameVerifier.class);
        throw new ClassNotFoundException(fqcn, new IllegalStateException(verifierClass.toString()));
    }

    private static void proxyConnect(Socket socket, String proxyHost, int proxyPort, String proxyUser, String proxyPassword, String host, int port, int cto) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("connecting through proxy " + proxyHost + ":" + proxyPort + " to " + host + ":" + port);
        }
        if (cto >= 0) {
            socket.connect(new InetSocketAddress(proxyHost, proxyPort), cto);
        } else {
            socket.connect(new InetSocketAddress(proxyHost, proxyPort));
        }
        PrintStream os = new PrintStream(socket.getOutputStream(), false, StandardCharsets.UTF_8.name());
        StringBuilder requestBuilder = new StringBuilder();
        requestBuilder.append("CONNECT ").append(host).append(":").append(port).append(" HTTP/1.1\r\n");
        requestBuilder.append("Host: ").append(host).append(":").append(port).append("\r\n");
        if (proxyUser != null && proxyPassword != null) {
            byte[] upbytes = (proxyUser + ':' + proxyPassword).getBytes(StandardCharsets.UTF_8);
            String proxyHeaderValue = new String(Base64.getEncoder().encode(upbytes), StandardCharsets.US_ASCII);
            requestBuilder.append("Proxy-Authorization: Basic ").append(proxyHeaderValue).append("\r\n");
        }
        requestBuilder.append("Proxy-Connection: keep-alive\r\n\r\n");
        os.print(requestBuilder.toString());
        os.flush();
        StringBuilder errorLine = new StringBuilder();
        if (!SocketFetcher.readProxyResponse(socket.getInputStream(), errorLine)) {
            try {
                socket.close();
            }
            catch (IOException proxyHeaderValue) {
                // empty catch block
            }
            ConnectException ex = new ConnectException("connection through proxy " + proxyHost + ":" + proxyPort + " to " + host + ":" + port + " failed: " + errorLine.toString());
            logger.log(Level.FINE, "connect failed", ex);
            throw ex;
        }
    }

    static boolean readProxyResponse(InputStream input, StringBuilder errorLine) throws IOException {
        String line;
        LineInputStream r = new LineInputStream(input, true);
        boolean first = true;
        while ((line = r.readLine()) != null && line.length() != 0) {
            logger.finest(line);
            if (!first) continue;
            StringTokenizer st = new StringTokenizer(line);
            String http = st.nextToken();
            String code = st.nextToken();
            if (!code.equals("200")) {
                errorLine.append(line);
                return false;
            }
            first = false;
        }
        return true;
    }

    private static String[] stringArray(String s2) {
        StringTokenizer st = new StringTokenizer(s2);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        return tokens.toArray(new String[0]);
    }

    private static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }

    private static final class JdkHostnameChecker
    implements HostnameVerifier {
        private final HostnameVerifier failover;

        static HostnameVerifier of() {
            return JdkHostnameChecker.ofFailover((n, s2) -> false);
        }

        static HostnameVerifier ofFailover(HostnameVerifier or) {
            return new JdkHostnameChecker(or);
        }

        private JdkHostnameChecker(HostnameVerifier or) {
            this.failover = Objects.requireNonNull(or);
        }

        @Override
        public boolean verify(String server, SSLSession ssls) {
            try {
                X509Certificate cert = SocketFetcher.getX509Certificate(ssls.getPeerCertificates());
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("matchCert server " + server + ", cert " + cert);
                }
                Class<?> hnc = Class.forName("sun.security.util.HostnameChecker");
                Method getInstance = hnc.getMethod("getInstance", Byte.TYPE);
                Object hostnameChecker = getInstance.invoke(null, (byte)2);
                logger.finer("using sun.security.util.HostnameChecker");
                Method match = hnc.getMethod("match", String.class, X509Certificate.class);
                try {
                    match.invoke(hostnameChecker, server, cert);
                    return true;
                }
                catch (InvocationTargetException ite) {
                    Throwable ce = ite.getCause();
                    if (ce instanceof CertificateException) {
                        logger.log(Level.FINER, "HostnameChecker DENY", ite);
                        throw new UndeclaredThrowableException(ce, this.toString() + " DENY");
                    }
                    throw ite;
                }
            }
            catch (IOException | ReflectiveOperationException roe) {
                logger.log(Level.FINER, "HostnameChecker FAIL", roe);
                try {
                    if (this.failover.verify(server, ssls)) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.log(Level.FINER, "allowed by: {0}", (Object)this.failover.toString());
                        }
                        return true;
                    }
                }
                catch (Throwable fail) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, this.toString() + "FAIL -> THROW", fail);
                    }
                    if (fail != roe) {
                        fail.addSuppressed(roe);
                    }
                    throw fail;
                }
                Throwable t2 = roe;
                if (roe instanceof InvocationTargetException) {
                    t2 = roe.getCause();
                }
                if (t2 == null) {
                    t2 = roe;
                }
                if (t2 instanceof RuntimeException) {
                    throw (RuntimeException)t2;
                }
                if (t2 instanceof Error) {
                    throw (Error)t2;
                }
                String msg = this.toString() + " FAIL -> DENY";
                if (t2 instanceof IOException) {
                    throw new UncheckedIOException(msg, (IOException)t2);
                }
                throw new UndeclaredThrowableException(t2, msg);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + " -> " + this.failover;
        }
    }

    private static final class MailHostnameVerifier
    implements HostnameVerifier {
        private static final HostnameVerifier OF = new MailHostnameVerifier();

        static HostnameVerifier of() {
            return OF;
        }

        private MailHostnameVerifier() {
        }

        @Override
        public boolean verify(String server, SSLSession ssls) {
            Objects.requireNonNull(server);
            X509Certificate cert = null;
            try {
                Collection<List<?>> names;
                cert = SocketFetcher.getX509Certificate(ssls.getPeerCertificates());
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("matchCert server " + server + ", cert " + cert);
                }
                if ((names = cert.getSubjectAlternativeNames()) != null) {
                    boolean foundName = false;
                    for (List<?> nameEnt : names) {
                        int type = (Integer)nameEnt.get(0);
                        if (type != 2) continue;
                        foundName = true;
                        String name = (String)nameEnt.get(1);
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("found name: " + name);
                        }
                        if (!MailHostnameVerifier.matchServer(server, name)) continue;
                        return true;
                    }
                    if (foundName) {
                        throw new UndeclaredThrowableException(new CertificateException("No subject alternative DNS name matching " + server + " found"), this.toString() + " DENY");
                    }
                }
            }
            catch (CertificateParsingException ignore) {
                logger.log(Level.FINEST, server, ignore);
            }
            catch (IOException spue) {
                throw new UncheckedIOException(this.toString() + " DENY", spue);
            }
            if (cert == null) {
                throw new UncheckedIOException(this.toString() + " DENY", new SSLPeerUnverifiedException("null"));
            }
            Pattern p = Pattern.compile("CN=([^,]*)");
            Matcher m4 = p.matcher(cert.getSubjectX500Principal().getName());
            if (m4.find() && MailHostnameVerifier.matchServer(server, m4.group(1).trim())) {
                return true;
            }
            throw new UndeclaredThrowableException(new CertificateException("No name matching " + server + " found"), this.toString() + " DENY");
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private static boolean matchServer(String server, String name) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("match server " + server + " with " + name);
            }
            if (name.startsWith("*.")) {
                String tail = name.substring(2);
                if (tail.length() == 0) {
                    return false;
                }
                int off = server.length() - tail.length();
                if (off < 1) {
                    return false;
                }
                return server.charAt(off - 1) == '.' && server.regionMatches(true, off, tail, 0, tail.length());
            }
            return server.equalsIgnoreCase(name);
        }
    }
}

