/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.pubsub.v1.CancellableRunnable;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;

final class SequentialExecutorService {
    private SequentialExecutorService() {
    }

    @BetaApi
    static class CallbackExecutor
    extends SequentialExecutor<CancellableRunnable> {
        static CancellationException CANCELLATION_EXCEPTION = new CancellationException("Execution cancelled because executing previous runnable failed.");
        private final Set<String> keysWithErrors = Collections.synchronizedSet(new HashSet());

        CallbackExecutor(Executor executor) {
            super(executor);
        }

        <T> ApiFuture<T> submit(final String key, final Callable<ApiFuture<T>> callable) {
            final SettableApiFuture future = SettableApiFuture.create();
            if (this.keysWithErrors.contains(key)) {
                future.setException(CANCELLATION_EXCEPTION);
                return future;
            }
            CancellableRunnable task = new CancellableRunnable(){
                private boolean cancelled = false;

                @Override
                public void run() {
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        ApiFutureCallback callback = new ApiFutureCallback<T>(){

                            @Override
                            public void onSuccess(T msg) {
                                this.callNextTaskAsync(key);
                                future.set(msg);
                            }

                            @Override
                            public void onFailure(Throwable e) {
                                future.setException(e);
                                this.cancelQueuedTasks(key, CANCELLATION_EXCEPTION);
                            }
                        };
                        ApiFutures.addCallback((ApiFuture)callable.call(), callback, MoreExecutors.directExecutor());
                    }
                    catch (Exception e) {
                        this.cancel(e);
                    }
                }

                @Override
                public void cancel(Throwable e) {
                    this.cancelled = true;
                    future.setException(e);
                }
            };
            this.execute(key, task);
            return future;
        }

        boolean keyHasError(String key) {
            return this.keysWithErrors.contains(key);
        }

        void resumePublish(String key) {
            this.keysWithErrors.remove(key);
        }

        void stopPublish(String key) {
            this.keysWithErrors.add(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelQueuedTasks(String key, Throwable e) {
            this.keysWithErrors.add(key);
            Map map = this.tasksByKey;
            synchronized (map) {
                Queue tasks = (Queue)this.tasksByKey.get(key);
                if (tasks != null) {
                    while (!tasks.isEmpty()) {
                        ((CancellableRunnable)tasks.poll()).cancel(e);
                    }
                    this.tasksByKey.remove(key);
                }
            }
        }
    }

    @BetaApi
    static class AutoExecutor
    extends SequentialExecutor<Runnable> {
        AutoExecutor(Executor executor) {
            super(executor);
        }

        void submit(final String key, final Runnable task) {
            super.execute(key, new Runnable(){

                @Override
                public void run() {
                    try {
                        task.run();
                    }
                    finally {
                        this.callNextTaskAsync(key);
                    }
                }
            });
        }
    }

    private static abstract class SequentialExecutor<R extends Runnable> {
        protected final Map<String, Queue<R>> tasksByKey;
        protected final Executor executor;

        private SequentialExecutor(Executor executor) {
            this.executor = executor;
            this.tasksByKey = new HashMap<String, Queue<R>>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasTasksInflight(String key) {
            Map<String, Queue<R>> map = this.tasksByKey;
            synchronized (map) {
                return this.tasksByKey.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void execute(String key, R task) {
            Map<String, Queue<R>> map = this.tasksByKey;
            synchronized (map) {
                Queue<R> newTasks = this.tasksByKey.get(key);
                if (newTasks != null) {
                    newTasks.add(task);
                    return;
                }
                newTasks = new LinkedList<R>();
                newTasks.add(task);
                this.tasksByKey.put(key, newTasks);
            }
            this.callNextTaskAsync(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void callNextTaskAsync(final String key) {
            boolean executeTask = true;
            Map<String, Queue<R>> map = this.tasksByKey;
            synchronized (map) {
                Queue<R> tasks = this.tasksByKey.get(key);
                if (tasks != null && tasks.isEmpty()) {
                    this.tasksByKey.remove(key);
                    executeTask = false;
                }
            }
            if (executeTask) {
                this.executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Runnable task = null;
                        Map map = tasksByKey;
                        synchronized (map) {
                            Queue tasks = tasksByKey.get(key);
                            if (tasks != null && !tasks.isEmpty()) {
                                task = (Runnable)tasks.poll();
                            }
                        }
                        if (task != null) {
                            task.run();
                        }
                    }
                });
            }
        }
    }
}

