/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SnapshotName
implements ResourceName {
    private static final PathTemplate PROJECT_SNAPSHOT = PathTemplate.createWithoutUrlEncoding("projects/{project}/snapshots/{snapshot}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String snapshot;

    @Deprecated
    protected SnapshotName() {
        this.project = null;
        this.snapshot = null;
    }

    private SnapshotName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.snapshot = Preconditions.checkNotNull(builder.getSnapshot());
    }

    public String getProject() {
        return this.project;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SnapshotName of(String project, String snapshot) {
        return SnapshotName.newBuilder().setProject(project).setSnapshot(snapshot).build();
    }

    public static String format(String project, String snapshot) {
        return SnapshotName.newBuilder().setProject(project).setSnapshot(snapshot).build().toString();
    }

    public static SnapshotName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_SNAPSHOT.validatedMatch(formattedString, "SnapshotName.parse: formattedString not in valid format");
        return SnapshotName.of(matchMap.get("project"), matchMap.get("snapshot"));
    }

    public static List<SnapshotName> parseList(List<String> formattedStrings) {
        ArrayList<SnapshotName> list = new ArrayList<SnapshotName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SnapshotName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SnapshotName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SnapshotName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SNAPSHOT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SnapshotName snapshotName = this;
            synchronized (snapshotName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.snapshot != null) {
                        fieldMapBuilder.put("snapshot", this.snapshot);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_SNAPSHOT.instantiate("project", this.project, "snapshot", this.snapshot);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SnapshotName that = (SnapshotName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.snapshot, that.snapshot);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.snapshot);
    }

    public static class Builder {
        private String project;
        private String snapshot;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSnapshot() {
            return this.snapshot;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSnapshot(String snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        private Builder(SnapshotName snapshotName) {
            this.project = snapshotName.project;
            this.snapshot = snapshotName.snapshot;
        }

        public SnapshotName build() {
            return new SnapshotName(this);
        }
    }
}

