/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.stub.GrpcPublisherCallableFactory;
import com.google.cloud.pubsub.v1.stub.PublisherStub;
import com.google.cloud.pubsub.v1.stub.PublisherStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.DetachSubscriptionRequest;
import com.google.pubsub.v1.DetachSubscriptionResponse;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListTopicSnapshotsRequest;
import com.google.pubsub.v1.ListTopicSnapshotsResponse;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.UpdateTopicRequest;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcPublisherStub
extends PublisherStub {
    private static final MethodDescriptor<Topic, Topic> createTopicMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/CreateTopic").setRequestMarshaller(ProtoUtils.marshaller(Topic.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Topic.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateTopicRequest, Topic> updateTopicMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/UpdateTopic").setRequestMarshaller(ProtoUtils.marshaller(UpdateTopicRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Topic.getDefaultInstance())).build();
    private static final MethodDescriptor<PublishRequest, PublishResponse> publishMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/Publish").setRequestMarshaller(ProtoUtils.marshaller(PublishRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(PublishResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetTopicRequest, Topic> getTopicMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/GetTopic").setRequestMarshaller(ProtoUtils.marshaller(GetTopicRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Topic.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTopicsRequest, ListTopicsResponse> listTopicsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/ListTopics").setRequestMarshaller(ProtoUtils.marshaller(ListTopicsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ListTopicsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/ListTopicSubscriptions").setRequestMarshaller(ProtoUtils.marshaller(ListTopicSubscriptionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ListTopicSubscriptionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse> listTopicSnapshotsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/ListTopicSnapshots").setRequestMarshaller(ProtoUtils.marshaller(ListTopicSnapshotsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ListTopicSnapshotsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteTopicRequest, Empty> deleteTopicMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/DeleteTopic").setRequestMarshaller(ProtoUtils.marshaller(DeleteTopicRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<DetachSubscriptionRequest, DetachSubscriptionResponse> detachSubscriptionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/DetachSubscription").setRequestMarshaller(ProtoUtils.marshaller(DetachSubscriptionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(DetachSubscriptionResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller(SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller(GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller(TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<Topic, Topic> createTopicCallable;
    private final UnaryCallable<UpdateTopicRequest, Topic> updateTopicCallable;
    private final UnaryCallable<PublishRequest, PublishResponse> publishCallable;
    private final UnaryCallable<GetTopicRequest, Topic> getTopicCallable;
    private final UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable;
    private final UnaryCallable<ListTopicsRequest, TopicAdminClient.ListTopicsPagedResponse> listTopicsPagedCallable;
    private final UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable;
    private final UnaryCallable<ListTopicSubscriptionsRequest, TopicAdminClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsPagedCallable;
    private final UnaryCallable<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse> listTopicSnapshotsCallable;
    private final UnaryCallable<ListTopicSnapshotsRequest, TopicAdminClient.ListTopicSnapshotsPagedResponse> listTopicSnapshotsPagedCallable;
    private final UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable;
    private final UnaryCallable<DetachSubscriptionRequest, DetachSubscriptionResponse> detachSubscriptionCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcPublisherStub create(PublisherStubSettings settings) throws IOException {
        return new GrpcPublisherStub(settings, ClientContext.create(settings));
    }

    public static final GrpcPublisherStub create(ClientContext clientContext) throws IOException {
        return new GrpcPublisherStub(PublisherStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcPublisherStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcPublisherStub(PublisherStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcPublisherStub(PublisherStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcPublisherCallableFactory());
    }

    protected GrpcPublisherStub(PublisherStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create(clientContext, callableFactory);
        GrpcCallSettings<Topic, Topic> createTopicTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTopicMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<UpdateTopicRequest, Topic> updateTopicTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateTopicMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("topic.name", String.valueOf(request.getTopic().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<PublishRequest, PublishResponse> publishTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(publishMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("topic", String.valueOf(request.getTopic()));
            return builder.build();
        }).build();
        GrpcCallSettings<GetTopicRequest, Topic> getTopicTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTopicMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("topic", String.valueOf(request.getTopic()));
            return builder.build();
        }).build();
        GrpcCallSettings<ListTopicsRequest, ListTopicsResponse> listTopicsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTopicsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        GrpcCallSettings<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTopicSubscriptionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("topic", String.valueOf(request.getTopic()));
            return builder.build();
        }).build();
        GrpcCallSettings<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse> listTopicSnapshotsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTopicSnapshotsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("topic", String.valueOf(request.getTopic()));
            return builder.build();
        }).build();
        GrpcCallSettings<DeleteTopicRequest, Empty> deleteTopicTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteTopicMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("topic", String.valueOf(request.getTopic()));
            return builder.build();
        }).build();
        GrpcCallSettings<DetachSubscriptionRequest, DetachSubscriptionResponse> detachSubscriptionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(detachSubscriptionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("subscription", String.valueOf(request.getSubscription()));
            return builder.build();
        }).build();
        GrpcCallSettings<SetIamPolicyRequest, Policy> setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings<GetIamPolicyRequest, Policy> getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createTopicCallable = callableFactory.createUnaryCallable(createTopicTransportSettings, settings.createTopicSettings(), clientContext);
        this.updateTopicCallable = callableFactory.createUnaryCallable(updateTopicTransportSettings, settings.updateTopicSettings(), clientContext);
        this.publishCallable = callableFactory.createBatchingCallable(publishTransportSettings, settings.publishSettings(), clientContext);
        this.getTopicCallable = callableFactory.createUnaryCallable(getTopicTransportSettings, settings.getTopicSettings(), clientContext);
        this.listTopicsCallable = callableFactory.createUnaryCallable(listTopicsTransportSettings, settings.listTopicsSettings(), clientContext);
        this.listTopicsPagedCallable = callableFactory.createPagedCallable(listTopicsTransportSettings, settings.listTopicsSettings(), clientContext);
        this.listTopicSubscriptionsCallable = callableFactory.createUnaryCallable(listTopicSubscriptionsTransportSettings, settings.listTopicSubscriptionsSettings(), clientContext);
        this.listTopicSubscriptionsPagedCallable = callableFactory.createPagedCallable(listTopicSubscriptionsTransportSettings, settings.listTopicSubscriptionsSettings(), clientContext);
        this.listTopicSnapshotsCallable = callableFactory.createUnaryCallable(listTopicSnapshotsTransportSettings, settings.listTopicSnapshotsSettings(), clientContext);
        this.listTopicSnapshotsPagedCallable = callableFactory.createPagedCallable(listTopicSnapshotsTransportSettings, settings.listTopicSnapshotsSettings(), clientContext);
        this.deleteTopicCallable = callableFactory.createUnaryCallable(deleteTopicTransportSettings, settings.deleteTopicSettings(), clientContext);
        this.detachSubscriptionCallable = callableFactory.createUnaryCallable(detachSubscriptionTransportSettings, settings.detachSubscriptionSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<Topic, Topic> createTopicCallable() {
        return this.createTopicCallable;
    }

    @Override
    public UnaryCallable<UpdateTopicRequest, Topic> updateTopicCallable() {
        return this.updateTopicCallable;
    }

    @Override
    public UnaryCallable<PublishRequest, PublishResponse> publishCallable() {
        return this.publishCallable;
    }

    @Override
    public UnaryCallable<GetTopicRequest, Topic> getTopicCallable() {
        return this.getTopicCallable;
    }

    @Override
    public UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable() {
        return this.listTopicsCallable;
    }

    @Override
    public UnaryCallable<ListTopicsRequest, TopicAdminClient.ListTopicsPagedResponse> listTopicsPagedCallable() {
        return this.listTopicsPagedCallable;
    }

    @Override
    public UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable() {
        return this.listTopicSubscriptionsCallable;
    }

    @Override
    public UnaryCallable<ListTopicSubscriptionsRequest, TopicAdminClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsPagedCallable() {
        return this.listTopicSubscriptionsPagedCallable;
    }

    @Override
    public UnaryCallable<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse> listTopicSnapshotsCallable() {
        return this.listTopicSnapshotsCallable;
    }

    @Override
    public UnaryCallable<ListTopicSnapshotsRequest, TopicAdminClient.ListTopicSnapshotsPagedResponse> listTopicSnapshotsPagedCallable() {
        return this.listTopicSnapshotsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable() {
        return this.deleteTopicCallable;
    }

    @Override
    public UnaryCallable<DetachSubscriptionRequest, DetachSubscriptionResponse> detachSubscriptionCallable() {
        return this.detachSubscriptionCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    @Override
    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

