/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets;

import com.google.api.services.sheets.v4.Sheets;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.sheets.BatchGoogleSheetsClientFactory;
import org.apache.camel.component.google.sheets.GoogleSheetsClientFactory;
import org.apache.camel.component.google.sheets.GoogleSheetsConfiguration;
import org.apache.camel.component.google.sheets.GoogleSheetsEndpoint;
import org.apache.camel.component.google.sheets.GoogleSheetsVerifierExtension;
import org.apache.camel.component.google.sheets.internal.GoogleSheetsApiCollection;
import org.apache.camel.component.google.sheets.internal.GoogleSheetsApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;

@Metadata(label="verifiers", enums="parameters,connectivity")
@Component(value="google-sheets")
public class GoogleSheetsComponent
extends AbstractApiComponent<GoogleSheetsApiName, GoogleSheetsConfiguration, GoogleSheetsApiCollection> {
    @Metadata
    GoogleSheetsConfiguration configuration;
    @Metadata(label="advanced")
    private Sheets client;
    @Metadata(label="advanced")
    private GoogleSheetsClientFactory clientFactory;

    public GoogleSheetsComponent() {
        super(GoogleSheetsApiName.class, GoogleSheetsApiCollection.getCollection());
        this.registerExtension(new GoogleSheetsVerifierExtension("google-sheets"));
    }

    public GoogleSheetsComponent(CamelContext context) {
        super(context, GoogleSheetsApiName.class, GoogleSheetsApiCollection.getCollection());
        this.registerExtension(new GoogleSheetsVerifierExtension("google-sheets", context));
    }

    @Override
    protected GoogleSheetsApiName getApiName(String apiNameStr) {
        return this.getCamelContext().getTypeConverter().convertTo(GoogleSheetsApiName.class, apiNameStr);
    }

    public Sheets getClient(GoogleSheetsConfiguration config) {
        if (this.client == null) {
            if (config.getClientId() != null && !config.getClientId().isBlank() && config.getClientSecret() != null && !config.getClientSecret().isBlank()) {
                this.client = this.getClientFactory().makeClient(config.getClientId(), config.getClientSecret(), config.getScopesAsList(), config.getApplicationName(), config.getRefreshToken(), config.getAccessToken());
            } else if (config.getServiceAccountKey() != null && !config.getServiceAccountKey().isBlank()) {
                this.client = this.getClientFactory().makeClient(this.getCamelContext(), config.getServiceAccountKey(), config.getScopesAsList(), config.getApplicationName(), config.getDelegate());
            } else {
                throw new IllegalArgumentException("(clientId and clientSecret) or serviceAccountKey are required to create Google Sheets client");
            }
        }
        return this.client;
    }

    public GoogleSheetsClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            this.clientFactory = new BatchGoogleSheetsClientFactory();
        }
        return this.clientFactory;
    }

    @Override
    public void setConfiguration(GoogleSheetsConfiguration configuration) {
        super.setConfiguration(configuration);
    }

    @Override
    public GoogleSheetsConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new GoogleSheetsConfiguration();
        }
        return (GoogleSheetsConfiguration)super.getConfiguration();
    }

    public void setClientFactory(GoogleSheetsClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String methodName, GoogleSheetsApiName apiName, GoogleSheetsConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new GoogleSheetsEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }
}

