/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets.stream;

import com.google.api.services.sheets.v4.Sheets;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.sheets.GoogleSheetsClientFactory;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamComponent;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamConfiguration;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamConstants;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamConsumer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.23.0", scheme="google-sheets-stream", title="Google Sheets Stream", syntax="google-sheets-stream:spreadsheetId", consumerOnly=true, category={Category.CLOUD, Category.DOCUMENT}, headersClass=GoogleSheetsStreamConstants.class)
public class GoogleSheetsStreamEndpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    @UriParam
    private GoogleSheetsStreamConfiguration configuration;

    public GoogleSheetsStreamEndpoint(String uri, GoogleSheetsStreamComponent component, GoogleSheetsStreamConfiguration endpointConfiguration) {
        super(uri, component);
        this.configuration = endpointConfiguration;
    }

    @Override
    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("The camel google sheets stream component doesn't support producer");
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        GoogleSheetsStreamConsumer consumer = new GoogleSheetsStreamConsumer(this, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    public Sheets getClient() {
        return ((GoogleSheetsStreamComponent)this.getComponent()).getClient(this.configuration);
    }

    public GoogleSheetsClientFactory getClientFactory() {
        return ((GoogleSheetsStreamComponent)this.getComponent()).getClientFactory();
    }

    public void setClientFactory(GoogleSheetsClientFactory clientFactory) {
        ((GoogleSheetsStreamComponent)this.getComponent()).setClientFactory(clientFactory);
    }

    public GoogleSheetsStreamConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getServiceUrl() {
        if (ObjectHelper.isNotEmpty(ObjectHelper.isNotEmpty(this.configuration.getApplicationName()) && ObjectHelper.isNotEmpty(this.configuration.getSpreadsheetId()))) {
            return this.getServiceProtocol() + ":" + this.configuration.getApplicationName() + ":" + this.configuration.getSpreadsheetId();
        }
        return null;
    }

    @Override
    public String getServiceProtocol() {
        return "sheets-stream";
    }
}

