/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grape;

import groovy.grape.Grape;
import groovy.lang.Closure;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.grape.GrapeComponent;
import org.apache.camel.component.grape.GrapeConstants;
import org.apache.camel.component.grape.GrapeProducer;
import org.apache.camel.component.grape.MavenCoordinates;
import org.apache.camel.component.grape.PatchesRepository;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

@UriEndpoint(firstVersion="2.16.0", scheme="grape", syntax="grape:defaultCoordinates", title="Grape", remote=false, producerOnly=true, category={Category.MANAGEMENT}, headersClass=GrapeConstants.class)
public class GrapeEndpoint
extends DefaultEndpoint {
    @UriPath(description="Maven coordinates to use as default to grab if the message body is empty.")
    @Metadata(required=true)
    private final String defaultCoordinates;

    public GrapeEndpoint(String endpointUri, String defaultCoordinates, GrapeComponent component) {
        super(endpointUri, component);
        this.defaultCoordinates = defaultCoordinates;
    }

    public static List<String> loadPatches(CamelContext camelContext) {
        final ClassLoader classLoader = camelContext.getApplicationContextClassLoader();
        PatchesRepository patchesRepository = camelContext.getComponent("grape", GrapeComponent.class).getPatchesRepository();
        return DefaultGroovyMethods.each(patchesRepository.listPatches(), (Closure)new Closure<Object>(null, null){

            public void doCall(String it) {
                MavenCoordinates coordinates = MavenCoordinates.parseMavenCoordinates(it);
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(5);
                map.put("classLoader", classLoader);
                map.put("group", coordinates.getGroupId());
                map.put("module", coordinates.getArtifactId());
                map.put("version", coordinates.getVersion());
                map.put("classifier", coordinates.getClassifier());
                Grape.grab(map);
            }

            public void doCall() {
                this.doCall(null);
            }
        });
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public Producer createProducer() {
        return new GrapeProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException("Grape component supports only the producer side of the route.");
    }

    public String getDefaultCoordinates() {
        return this.defaultCoordinates;
    }

    @Override
    public GrapeComponent getComponent() {
        return DefaultGroovyMethods.asType(super.getComponent(), GrapeComponent.class);
    }
}

