/*
 * Decompiled with CFR 0.152.
 */
package io.krakens.grok.api;

import io.krakens.grok.api.Grok;
import io.krakens.grok.api.GrokCompiler;
import io.krakens.grok.api.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Discovery {
    private Grok grok;

    public Discovery(Grok grok) {
        this.grok = grok;
    }

    private Map<String, Grok> sort(Map<String, Grok> groks) {
        ArrayList<Grok> groky = new ArrayList<Grok>(groks.values());
        LinkedHashMap<String, Grok> grokMap = new LinkedHashMap<String, Grok>();
        Collections.sort(groky, new Comparator<Grok>(){

            @Override
            public int compare(Grok g1, Grok g2) {
                return this.complexity(g1.getNamedRegex()) < this.complexity(g2.getNamedRegex()) ? 1 : 0;
            }

            private int complexity(String expandedPattern) {
                int score = 0;
                score += expandedPattern.split("\\Q|\\E", -1).length - 1;
                return score += expandedPattern.length();
            }
        });
        for (Grok grok : groky) {
            grokMap.put(grok.getSaved_pattern(), grok);
        }
        return grokMap;
    }

    private int complexity(String expandedPattern) {
        int score = 0;
        score += expandedPattern.split("\\Q|\\E", -1).length - 1;
        return score += expandedPattern.length();
    }

    public String discover(String text) {
        String key;
        if (text == null) {
            return "";
        }
        TreeMap<String, Grok> groks = new TreeMap<String, Grok>();
        Map<String, String> grokPatterns = this.grok.getPatterns();
        String texte = text;
        GrokCompiler compiler = GrokCompiler.newInstance();
        compiler.register(grokPatterns);
        Iterator<Map.Entry<String, String>> iterator = grokPatterns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> stringStringEntry;
            Map.Entry<String, String> entry = stringStringEntry = iterator.next();
            key = entry.getKey().toString();
            try {
                Grok grok = compiler.compile("%{" + key + "}");
                grok.setSaved_pattern(key);
                groks.put(key, grok);
            }
            catch (Exception grok) {}
        }
        Map<String, Grok> patterns = this.sort(groks);
        for (Map.Entry<String, Grok> entry : patterns.entrySet()) {
            Pattern pattern2;
            Matcher ma2;
            Match match;
            key = entry.getKey();
            Grok value = entry.getValue();
            if (this.complexity(value.getNamedRegex()) < 20 || (match = value.match(text)).isNull().booleanValue()) continue;
            String part = this.getPart(match, text);
            Pattern pattern = Pattern.compile(".\\b.");
            Matcher ma = pattern.matcher(part);
            if (!ma.find() || (ma2 = (pattern2 = Pattern.compile("%\\{[^}+]\\}")).matcher(part)).find()) continue;
            texte = StringUtils.replace(texte, part, "%{" + key + "}");
        }
        return texte;
    }

    private String getPart(Match matcher, String text) {
        if (matcher == null || text == null) {
            return "";
        }
        return text.substring(matcher.getStart(), matcher.getEnd());
    }
}

