/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class GrpcEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port/service";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    @Override
    public boolean isEnabled(String scheme) {
        return "grpc".equals(scheme);
    }

    @Override
    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "service", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    @Override
    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    @Override
    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(45);
        props.add("authenticationType");
        props.add("autoDiscoverClientInterceptors");
        props.add("autoDiscoverServerInterceptors");
        props.add("bridgeErrorHandler");
        props.add("consumerStrategy");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("flowControlWindow");
        props.add("forwardOnCompleted");
        props.add("forwardOnError");
        props.add("host");
        props.add("inheritExchangePropertiesForReplies");
        props.add("initialFlowControlWindow");
        props.add("jwtAlgorithm");
        props.add("jwtIssuer");
        props.add("jwtSecret");
        props.add("jwtSubject");
        props.add("keepAliveTime");
        props.add("keepAliveTimeout");
        props.add("keyCertChainResource");
        props.add("keyPassword");
        props.add("keyResource");
        props.add("lazyStartProducer");
        props.add("maxConcurrentCallsPerConnection");
        props.add("maxConnectionAge");
        props.add("maxConnectionAgeGrace");
        props.add("maxConnectionIdle");
        props.add("maxInboundMetadataSize");
        props.add("maxMessageSize");
        props.add("maxRstFramesPerWindow");
        props.add("maxRstPeriodSeconds");
        props.add("method");
        props.add("negotiationType");
        props.add("permitKeepAliveTime");
        props.add("permitKeepAliveWithoutCalls");
        props.add("port");
        props.add("producerStrategy");
        props.add("routeControlledStreamObserver");
        props.add("service");
        props.add("serviceAccountResource");
        props.add("streamRepliesTo");
        props.add("synchronous");
        props.add("toRouteControlledStreamObserver");
        props.add("trustCertCollectionResource");
        props.add("userAgent");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("jwtSecret");
        secretProps.add("keyPassword");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

