/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.server;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.internal.GrpcUtil;

public class GrpcHeaderInterceptor
implements ServerInterceptor {
    public static final Context.Key<String> USER_AGENT_CONTEXT_KEY = Context.key("CamelGrpcUserAgent");
    public static final Context.Key<String> CONTENT_TYPE_CONTEXT_KEY = Context.key("Content-Type");

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
        Context context = Context.current().withValue(USER_AGENT_CONTEXT_KEY, requestHeaders.get(GrpcUtil.USER_AGENT_KEY)).withValue(CONTENT_TYPE_CONTEXT_KEY, requestHeaders.get(GrpcUtil.CONTENT_TYPE_KEY));
        return Contexts.interceptCall(context, call, requestHeaders, next);
    }
}

