/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import io.grpc.stub.StreamObserver;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultProducer;

public class GrpcProducerToRouteControlledStreamObserver
extends DefaultProducer {
    public GrpcProducerToRouteControlledStreamObserver(Endpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String eventType;
        StreamObserver observer = exchange.getProperty("grpcResponseObserver", StreamObserver.class);
        switch (eventType = exchange.getMessage().getHeader("CamelGrpcEventType", String.class)) {
            case "onNext": {
                observer.onNext(exchange.getMessage().getBody());
                break;
            }
            case "onCompleted": {
                observer.onCompleted();
                break;
            }
            case "onError": {
                observer.onError((Throwable)exchange.getMessage().getBody());
            }
        }
    }
}

