/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.auth.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import org.apache.camel.component.grpc.auth.jwt.JwtAlgorithm;

public final class JwtHelper {
    private JwtHelper() {
    }

    public static String createJwtToken(JwtAlgorithm algorithmName, String secret, String issuer, String subject) {
        try {
            Algorithm algorithm = JwtHelper.selectAlgorithm(algorithmName, secret);
            return JWT.create().withIssuer(issuer).withSubject(subject).sign(algorithm);
        }
        catch (JWTCreationException e) {
            throw new IllegalArgumentException("Unable to create JWT token", e);
        }
    }

    public static Algorithm selectAlgorithm(JwtAlgorithm algorithmName, String secret) throws IllegalArgumentException {
        switch (algorithmName) {
            case HMAC256: {
                return Algorithm.HMAC256(secret);
            }
            case HMAC384: {
                return Algorithm.HMAC384(secret);
            }
            case HMAC512: {
                return Algorithm.HMAC512(secret);
            }
        }
        throw new IllegalArgumentException("JWT algorithm " + String.valueOf((Object)algorithmName) + " not implemented");
    }
}

