/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.stream.JsonReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatContentTypeHeader;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;

@Dataformat(value="gson")
@Metadata(includeProperties="unmarshalType,unmarshalTypeName,prettyPrint,dateFormatPattern,contentTypeHeader")
public class GsonDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
DataFormatContentTypeHeader,
CamelContextAware {
    private CamelContext camelContext;
    private Gson gson;
    private Class<?> unmarshalType;
    private String unmarshalTypeName;
    private Type unmarshalGenericType;
    private List<ExclusionStrategy> exclusionStrategies;
    private LongSerializationPolicy longSerializationPolicy;
    private FieldNamingPolicy fieldNamingPolicy;
    private FieldNamingStrategy fieldNamingStrategy;
    private boolean serializeNulls;
    private boolean prettyPrint;
    private String dateFormatPattern;
    private boolean contentTypeHeader = true;

    public GsonDataFormat() {
        this(Object.class);
    }

    public GsonDataFormat(Class<?> unmarshalType) {
        this(null, unmarshalType);
    }

    @Deprecated
    public GsonDataFormat(Class<?> unmarshalType, ExclusionStrategy ... exclusionStrategies) {
        this(null, unmarshalType);
        this.setExclusionStrategies(Arrays.asList(exclusionStrategies));
    }

    public GsonDataFormat(Gson gson, Class<?> unmarshalType) {
        this.gson = gson;
        this.unmarshalType = unmarshalType;
    }

    public GsonDataFormat(Type unmarshalGenericType) {
        this(null, unmarshalGenericType);
    }

    public GsonDataFormat(Gson gson, Type unmarshalGenericType) {
        this.gson = gson;
        this.unmarshalGenericType = unmarshalGenericType;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public String getDataFormatName() {
        return "gson";
    }

    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        try (OutputStreamWriter osw = new OutputStreamWriter(stream, ExchangeHelper.getCharsetName(exchange));
             BufferedWriter writer = IOHelper.buffered(osw);){
            this.gson.toJson(graph, (Appendable)writer);
        }
        if (this.contentTypeHeader) {
            exchange.getMessage().setHeader("Content-Type", "application/json");
        }
    }

    @Override
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.unmarshal(exchange, (Object)stream);
    }

    @Override
    public Object unmarshal(Exchange exchange, Object body) throws Exception {
        Class<?> clazz = this.unmarshalType;
        String type = exchange.getIn().getHeader("CamelGsonUnmarshalType", String.class);
        if (type != null) {
            clazz = exchange.getContext().getClassResolver().resolveMandatoryClass(type);
        }
        if (body instanceof String) {
            String str = (String)body;
            if (this.unmarshalGenericType == null) {
                return this.gson.fromJson(str, clazz);
            }
            return this.gson.fromJson(str, this.unmarshalGenericType);
        }
        if (body instanceof Reader) {
            Reader r = (Reader)body;
            if (this.unmarshalGenericType == null) {
                return this.gson.fromJson(r, clazz);
            }
            return this.gson.fromJson(r, this.unmarshalGenericType);
        }
        if (body instanceof JsonReader) {
            JsonReader r = (JsonReader)body;
            if (this.unmarshalGenericType == null) {
                return this.gson.fromJson(r, clazz);
            }
            return this.gson.fromJson(r, this.unmarshalGenericType);
        }
        InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, body);
        InputStreamReader r = new InputStreamReader(is);
        if (this.unmarshalGenericType == null) {
            return this.gson.fromJson((Reader)r, clazz);
        }
        return this.gson.fromJson((Reader)r, this.unmarshalGenericType);
    }

    @Override
    protected void doInit() throws Exception {
        if (this.unmarshalTypeName != null && (this.unmarshalType == null || this.unmarshalType == Object.class)) {
            this.unmarshalType = this.camelContext.getClassResolver().resolveClass(this.unmarshalTypeName);
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this.gson == null) {
            GsonBuilder builder = new GsonBuilder();
            if (this.exclusionStrategies != null && !this.exclusionStrategies.isEmpty()) {
                ExclusionStrategy[] strategies = this.exclusionStrategies.toArray(new ExclusionStrategy[0]);
                builder.setExclusionStrategies(strategies);
            }
            if (this.longSerializationPolicy != null) {
                builder.setLongSerializationPolicy(this.longSerializationPolicy);
            }
            if (this.fieldNamingPolicy != null) {
                builder.setFieldNamingPolicy(this.fieldNamingPolicy);
            }
            if (this.fieldNamingStrategy != null) {
                builder.setFieldNamingStrategy(this.fieldNamingStrategy);
            }
            if (this.serializeNulls) {
                builder.serializeNulls();
            }
            if (this.prettyPrint) {
                builder.setPrettyPrinting();
            }
            if (this.dateFormatPattern != null) {
                builder.setDateFormat(this.dateFormatPattern);
            }
            this.gson = builder.create();
        }
    }

    @Override
    protected void doStop() throws Exception {
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Type getUnmarshalGenericType() {
        return this.unmarshalGenericType;
    }

    public void setUnmarshalGenericType(Type unmarshalGenericType) {
        this.unmarshalGenericType = unmarshalGenericType;
    }

    public List<ExclusionStrategy> getExclusionStrategies() {
        return this.exclusionStrategies;
    }

    public void setExclusionStrategies(List<ExclusionStrategy> exclusionStrategies) {
        this.exclusionStrategies = exclusionStrategies;
    }

    public LongSerializationPolicy getLongSerializationPolicy() {
        return this.longSerializationPolicy;
    }

    public void setLongSerializationPolicy(LongSerializationPolicy longSerializationPolicy) {
        this.longSerializationPolicy = longSerializationPolicy;
    }

    public FieldNamingPolicy getFieldNamingPolicy() {
        return this.fieldNamingPolicy;
    }

    public void setFieldNamingPolicy(FieldNamingPolicy fieldNamingPolicy) {
        this.fieldNamingPolicy = fieldNamingPolicy;
    }

    public FieldNamingStrategy getFieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    public void setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy;
    }

    @Deprecated
    public Boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public boolean isSerializeNulls() {
        return this.serializeNulls;
    }

    @Deprecated
    public void setSerializeNulls(Boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    public void setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    @Deprecated
    public Boolean getPrettyPrinting() {
        return this.prettyPrint;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @Deprecated
    public void setPrettyPrinting(Boolean prettyPrinting) {
        this.prettyPrint = prettyPrinting;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public boolean isContentTypeHeader() {
        return this.contentTypeHeader;
    }

    @Override
    public void setContentTypeHeader(boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public Gson getGson() {
        return this.gson;
    }
}

