/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.impl;

import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.internal.monitor.impl.LocalTopicStatsImpl;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.spi.impl.AbstractDistributedObject;
import com.hazelcast.spi.impl.InitializingObject;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.topic.LocalTopicStats;
import com.hazelcast.topic.MessageListener;
import com.hazelcast.topic.impl.TopicService;
import java.util.UUID;
import javax.annotation.Nonnull;

public abstract class TopicProxySupport
extends AbstractDistributedObject<TopicService>
implements InitializingObject {
    private final String name;
    private final TopicService topicService;
    private final LocalTopicStatsImpl topicStats;
    private final OperationService operationService;
    private final int partitionId;
    private boolean multithreaded;
    private ClassLoader classLoader;

    public TopicProxySupport(String name, NodeEngine nodeEngine, TopicService service) {
        super(nodeEngine, service);
        this.name = name;
        this.topicService = service;
        this.topicStats = this.topicService.getLocalTopicStats(name);
        this.operationService = nodeEngine.getOperationService();
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(this.getNameAsPartitionAwareData());
    }

    @Override
    public void initialize() {
        NodeEngine nodeEngine = this.getNodeEngine();
        TopicConfig config = nodeEngine.getConfig().findTopicConfig(this.name);
        this.multithreaded = config.isMultiThreadingEnabled();
        this.classLoader = NamespaceUtil.getClassLoaderForNamespace(nodeEngine, config.getUserCodeNamespace());
        for (ListenerConfig listenerConfig : config.getMessageListenerConfigs()) {
            this.initialize(listenerConfig);
        }
    }

    private void initialize(ListenerConfig listenerConfig) {
        MessageListener listener = this.loadListener(listenerConfig);
        if (listener == null) {
            return;
        }
        this.addMessageListenerInternal(listener);
    }

    private MessageListener loadListener(ListenerConfig listenerConfig) {
        try {
            MessageListener listener = (MessageListener)listenerConfig.getImplementation();
            if (listener == null && listenerConfig.getClassName() != null) {
                listener = (MessageListener)ClassLoaderUtil.newInstance(this.classLoader, listenerConfig.getClassName());
            }
            return listener;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public LocalTopicStats getLocalTopicStatsInternal() {
        return this.topicService.getLocalTopicStats(this.name);
    }

    public void publishInternal(@Nonnull Object message) {
        this.topicService.publishMessage(this.name, message, this.multithreaded);
        this.topicStats.incrementPublishes();
    }

    @Nonnull
    public UUID addMessageListenerInternal(@Nonnull MessageListener listener) {
        if (listener instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)((Object)listener)).setHazelcastInstance(this.getNodeEngine().getHazelcastInstance());
        }
        return this.topicService.addMessageListener(this.name, listener);
    }

    public boolean removeMessageListenerInternal(@Nonnull UUID registrationId) {
        return this.topicService.removeMessageListener(this.name, registrationId);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:topicService";
    }

    @Override
    public String getName() {
        return this.name;
    }
}

