/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.impl.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.client.impl.spi.impl.InvocationMightContainCompactDataException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.spi.impl.operationservice.impl.BaseInvocation;
import com.hazelcast.spi.impl.sequence.CallIdSequence;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ClientInvocation
extends BaseInvocation
implements Runnable {
    private static final AtomicReferenceFieldUpdater<ClientInvocation, ClientConnection> SENT_CONNECTION = AtomicReferenceFieldUpdater.newUpdater(ClientInvocation.class, ClientConnection.class, "sentConnection");
    private static final int MAX_FAST_INVOCATION_COUNT = 5;
    private static final int UNASSIGNED_PARTITION = -1;
    private static final AtomicLongFieldUpdater<ClientInvocation> INVOKE_COUNT = AtomicLongFieldUpdater.newUpdater(ClientInvocation.class, "invokeCount");
    final LifecycleService lifecycleService;
    private final ClientInvocationFuture clientInvocationFuture;
    private final ClientInvocationServiceImpl invocationService;
    private final TaskScheduler executionService;
    private volatile ClientMessage clientMessage;
    private final CallIdSequence callIdSequence;
    private final UUID uuid;
    private final int partitionId;
    private final ClientConnection connection;
    private final long startTimeMillis;
    private final long retryPauseMillis;
    private final Object objectName;
    private final boolean isUnisocketClient;
    private volatile ClientConnection sentConnection;
    private EventHandler handler;
    private volatile long invokeCount;
    private volatile long invocationTimeoutMillis;
    private boolean urgent;
    private boolean allowRetryOnRandom = true;
    private volatile boolean invoked;

    protected ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Object objectName, int partitionId, UUID uuid, ClientConnection connection) {
        super(((ClientInvocationServiceImpl)client.getInvocationService()).invocationLogger);
        this.lifecycleService = client.getLifecycleService();
        this.invocationService = (ClientInvocationServiceImpl)client.getInvocationService();
        this.executionService = client.getTaskScheduler();
        this.objectName = objectName;
        this.clientMessage = clientMessage;
        this.partitionId = partitionId;
        this.uuid = uuid;
        this.connection = connection;
        this.startTimeMillis = System.currentTimeMillis();
        this.retryPauseMillis = this.invocationService.getInvocationRetryPauseMillis();
        this.callIdSequence = this.invocationService.getCallIdSequence();
        this.clientInvocationFuture = new ClientInvocationFuture(this, clientMessage, this.logger, this.callIdSequence);
        this.invocationTimeoutMillis = this.invocationService.getInvocationTimeoutMillis();
        this.isUnisocketClient = this.invocationService.isUnisocketClient();
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Object objectName) {
        this(client, clientMessage, objectName, -1, null, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Object objectName, int partitionId) {
        this(client, clientMessage, objectName, partitionId, null, null);
        clientMessage.setPartitionId(partitionId);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Object objectName, UUID uuid) {
        this(client, clientMessage, objectName, -1, uuid, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Object objectName, ClientConnection connection) {
        this(client, clientMessage, objectName, -1, null, connection);
    }

    public ClientMessage getClientMessage() {
        return this.clientMessage;
    }

    public void disallowRetryOnRandom() {
        this.allowRetryOnRandom = false;
    }

    public ClientInvocationFuture invoke() {
        this.clientMessage.setCorrelationId(this.callIdSequence.next());
        this.invokeOnSelection();
        return this.clientInvocationFuture;
    }

    public ClientInvocationFuture invokeUrgent() {
        this.urgent = true;
        this.clientMessage.setCorrelationId(this.callIdSequence.forceNext());
        this.invokeOnSelection();
        return this.clientInvocationFuture;
    }

    private void invokeOnSelection() {
        try {
            boolean invoked;
            INVOKE_COUNT.incrementAndGet(this);
            if (this.urgent) {
                this.invocationService.checkUrgentInvocationAllowed(this);
            } else {
                this.invocationService.checkInvocationAllowed();
            }
            if (this.isBindToSingleConnection()) {
                boolean invoked2 = this.invocationService.invokeOnConnection(this, this.connection);
                if (!invoked2) {
                    this.notifyExceptionWithOwnedPermission(new IOException("Could not invoke on connection " + this.connection));
                }
                return;
            }
            if (!this.isUnisocketClient) {
                invoked = this.partitionId != -1 ? this.invocationService.invokeOnPartitionOwner(this, this.partitionId) : (this.uuid != null ? this.invocationService.invokeOnTarget(this, this.uuid) : this.invocationService.invoke(this));
                if (this.allowRetryOnRandom && !invoked) {
                    invoked = this.invocationService.invoke(this);
                }
            } else {
                invoked = this.invocationService.invoke(this);
            }
            if (!invoked) {
                this.notifyExceptionWithOwnedPermission(new IOException("No connection found to invoke"));
            }
        }
        catch (Throwable e) {
            this.notifyExceptionWithOwnedPermission(e);
        }
    }

    @Override
    public void run() {
        this.retry();
    }

    private void retry() {
        long correlationId = this.callIdSequence.forceNext();
        this.clientMessage = this.clientMessage.copyWithNewCorrelationId(correlationId);
        this.callIdSequence.complete();
        this.invokeOnSelection();
    }

    public void setInvocationTimeoutMillis(long invocationTimeoutMillis) {
        this.invocationTimeoutMillis = invocationTimeoutMillis;
    }

    void notify(ClientMessage clientMessage) {
        assert (clientMessage != null) : "response can't be null";
        if (this.getPermissionToNotify(clientMessage.getCorrelationId())) {
            byte expectedBackups = clientMessage.getNumberOfBackupAcks();
            this.notifyResponse(clientMessage, expectedBackups);
        }
    }

    boolean getPermissionToNotify(long responseCorrelationId) {
        ClientConnection conn = this.sentConnection;
        if (conn == null) {
            return false;
        }
        long requestCorrelationId = this.clientMessage.getCorrelationId();
        if (responseCorrelationId != requestCorrelationId) {
            return false;
        }
        return SENT_CONNECTION.compareAndSet(this, conn, null);
    }

    boolean getPermissionToNotifyForDeadConnection(ClientConnection deadConnection) {
        return SENT_CONNECTION.compareAndSet(this, deadConnection, null);
    }

    @Override
    protected boolean shouldCompleteWithoutBackups() {
        return true;
    }

    @Override
    protected void complete(Object response) {
        this.clientInvocationFuture.complete(response);
        this.invocationService.deRegisterInvocation(this.clientMessage.getCorrelationId());
    }

    @Override
    protected void completeExceptionally(Throwable t) {
        this.clientInvocationFuture.completeExceptionally(t);
        this.invocationService.deRegisterInvocation(this.clientMessage.getCorrelationId());
    }

    @Override
    protected boolean shouldFailOnIndeterminateOperationState() {
        return this.invocationService.shouldFailOnIndeterminateOperationState();
    }

    void notifyException(long correlationId, Throwable exception) {
        if (this.getPermissionToNotify(correlationId)) {
            this.notifyExceptionWithOwnedPermission(exception);
        }
    }

    void notifyExceptionWithOwnedPermission(Throwable exception) {
        this.logException(exception);
        if (!this.lifecycleService.isRunning()) {
            this.completeExceptionally(new HazelcastClientNotActiveException("Client is shutting down", exception));
            return;
        }
        if (!this.shouldRetry(exception)) {
            this.completeExceptionally(exception);
            return;
        }
        long timePassed = System.currentTimeMillis() - this.startTimeMillis;
        if (timePassed > this.invocationTimeoutMillis) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Exception will not be retried because invocation timed out", exception);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this);
            sb.append(" timed out because exception occurred after client invocation timeout ");
            sb.append(this.invocationService.getInvocationTimeoutMillis()).append(" ms. ");
            sb.append("Current time: ").append(StringUtil.timeToString(Clock.currentTimeMillis())).append(". ");
            sb.append("Start time: ").append(StringUtil.timeToString(this.startTimeMillis)).append(". ");
            sb.append("Total elapsed time: ").append(Clock.currentTimeMillis() - this.startTimeMillis).append(" ms. ");
            String msg = sb.toString();
            this.completeExceptionally(new OperationTimeoutException(msg, exception));
            return;
        }
        try {
            this.execute();
        }
        catch (RejectedExecutionException e) {
            this.completeExceptionally(new HazelcastClientNotActiveException("Client is shutting down", exception));
        }
    }

    private void logException(Throwable exception) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Invocation got an exception " + this + ", invoke count : " + this.invokeCount + ", exception : " + exception.getClass() + ", message : " + exception.getMessage() + (String)(exception.getCause() != null ? ", cause :" + exception.getCause() : ""));
        }
    }

    private void execute() {
        this.invocationService.deRegisterInvocation(this.clientMessage.getCorrelationId());
        if (this.invokeCount < 5L) {
            this.executionService.execute(this);
        } else {
            long delayMillis = Math.min(1L << (int)Math.min(62L, this.invokeCount - 5L), this.retryPauseMillis);
            this.executionService.schedule(this, delayMillis, TimeUnit.MILLISECONDS);
        }
    }

    private boolean isBindToSingleConnection() {
        return this.connection != null;
    }

    EventHandler getEventHandler() {
        return this.handler;
    }

    public void setEventHandler(EventHandler handler) {
        this.handler = handler;
    }

    public void setSentConnection(ClientConnection connection) {
        SENT_CONNECTION.set(this, connection);
    }

    void invoked() {
        this.invoked = true;
    }

    public void waitInvoked() throws InterruptedException {
        while (!this.invoked && !this.clientInvocationFuture.isDone()) {
            Thread.sleep(this.retryPauseMillis);
        }
    }

    private boolean shouldRetry(Throwable t) {
        if (t instanceof InvocationMightContainCompactDataException) {
            return true;
        }
        if (this.isBindToSingleConnection() && (t instanceof IOException || t instanceof TargetDisconnectedException)) {
            return false;
        }
        if (this.uuid != null && t instanceof TargetNotMemberException) {
            return false;
        }
        if (t instanceof IOException || t instanceof HazelcastInstanceNotActiveException || t instanceof RetryableException) {
            return true;
        }
        if (t instanceof TargetDisconnectedException) {
            return this.clientMessage.isRetryable() || this.invocationService.isRedoOperation();
        }
        return false;
    }

    public String toString() {
        Object target = this.isBindToSingleConnection() ? "connection " + this.connection : (this.partitionId != -1 ? "partition " + this.partitionId : (this.uuid != null ? "uuid " + this.uuid : "random"));
        return "ClientInvocation{clientMessage = " + this.clientMessage + ", objectName = " + this.objectName + ", target = " + (String)target + ", sentConnection = " + this.sentConnection + "}";
    }

    CallIdSequence getCallIdSequence() {
        return this.callIdSequence;
    }

    public ClientInvocationFuture getClientInvocationFuture() {
        return this.clientInvocationFuture;
    }
}

