/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.set;

import com.hazelcast.collection.LocalSetStats;
import com.hazelcast.collection.impl.collection.CollectionContainer;
import com.hazelcast.collection.impl.collection.CollectionService;
import com.hazelcast.collection.impl.set.SetContainer;
import com.hazelcast.collection.impl.set.SetProxyImpl;
import com.hazelcast.collection.impl.set.operations.SetReplicationOperation;
import com.hazelcast.collection.impl.txnset.TransactionalSetProxy;
import com.hazelcast.config.SetConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.impl.ProviderHelper;
import com.hazelcast.internal.monitor.impl.LocalSetStatsImpl;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.services.StatisticsAwareService;
import com.hazelcast.internal.services.TenantContextAwareService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.transaction.impl.Transaction;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SetService
extends CollectionService
implements DynamicMetricsProvider,
StatisticsAwareService<LocalSetStats>,
TenantContextAwareService {
    public static final String SERVICE_NAME = "hz:impl:setService";
    private static final Object NULL_OBJECT = new Object();
    private final ConcurrentMap<String, SetContainer> containerMap = new ConcurrentHashMap<String, SetContainer>();
    private final ConcurrentMap<String, Object> splitBrainProtectionConfigCache = new ConcurrentHashMap<String, Object>();
    private final ContextMutexFactory splitBrainProtectionConfigCacheMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, Object> splitBrainProtectionConfigConstructor = new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            SetConfig lockConfig = SetService.this.nodeEngine.getConfig().findSetConfig(name);
            String splitBrainProtectionName = lockConfig.getSplitBrainProtectionName();
            return splitBrainProtectionName == null ? NULL_OBJECT : splitBrainProtectionName;
        }
    };
    private final ConcurrentMap<String, LocalSetStatsImpl> statsMap = new ConcurrentHashMap<String, LocalSetStatsImpl>();
    private final ConstructorFunction<String, LocalSetStatsImpl> localCollectionStatsConstructorFunction = key -> new LocalSetStatsImpl();

    public SetService(NodeEngine nodeEngine) {
        super(nodeEngine);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        boolean dsMetricsEnabled = nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES);
        if (dsMetricsEnabled) {
            ((NodeEngineImpl)nodeEngine).getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
        super.init(nodeEngine, properties);
    }

    @Override
    public SetContainer getOrCreateContainer(String name, boolean backup) {
        SetContainer current;
        SetContainer container = (SetContainer)this.containerMap.get(name);
        if (container == null && (current = this.containerMap.putIfAbsent(name, container = new SetContainer(name, this.nodeEngine))) != null) {
            container = current;
        }
        return container;
    }

    @Override
    public ConcurrentMap<String, ? extends CollectionContainer> getContainerMap() {
        return this.containerMap;
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public DistributedObject createDistributedObject(String objectId, UUID source, boolean local) {
        return new SetProxyImpl(objectId, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String name, boolean local) {
        super.destroyDistributedObject(name, local);
        this.splitBrainProtectionConfigCache.remove(name);
    }

    public TransactionalSetProxy createTransactionalObject(String name, Transaction transaction) {
        return new TransactionalSetProxy(name, transaction, this.nodeEngine, this);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        Map<String, CollectionContainer> migrationData = this.getMigrationData(event);
        return migrationData.isEmpty() ? null : new SetReplicationOperation(migrationData, event.getPartitionId(), event.getReplicaIndex());
    }

    @Override
    public String getSplitBrainProtectionName(String name) {
        Object splitBrainProtectionName = ConcurrencyUtil.getOrPutSynchronized(this.splitBrainProtectionConfigCache, name, this.splitBrainProtectionConfigCacheMutexFactory, this.splitBrainProtectionConfigConstructor);
        return splitBrainProtectionName == NULL_OBJECT ? null : (String)splitBrainProtectionName;
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        ProviderHelper.provide(descriptor, context, "set", this.getStats());
    }

    @Override
    public Map<String, LocalSetStats> getStats() {
        Map<String, LocalSetStats> setStats = MapUtil.createHashMap(this.containerMap.size());
        for (Map.Entry entry : this.containerMap.entrySet()) {
            String name = (String)entry.getKey();
            SetContainer setContainer = (SetContainer)entry.getValue();
            if (!setContainer.getConfig().isStatisticsEnabled()) continue;
            LocalSetStatsImpl setStat = this.getLocalCollectionStats(name);
            setStats.put(name, setStat);
        }
        return setStats;
    }

    @Override
    public LocalSetStatsImpl getLocalCollectionStats(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.localCollectionStatsConstructorFunction);
    }

    public static String lookupNamespace(NodeEngine engine, String setName) {
        if (engine.getNamespaceService().isEnabled()) {
            SetService service = (SetService)engine.getService(SERVICE_NAME);
            return service.lookupNamespace(setName);
        }
        return null;
    }

    @Override
    protected String lookupNamespace(String setName) {
        SetContainer container = (SetContainer)this.containerMap.get(setName);
        if (container != null) {
            return container.getConfig().getUserCodeNamespace();
        }
        SetConfig config = this.nodeEngine.getConfig().findSetConfig(setName);
        if (config != null) {
            return config.getUserCodeNamespace();
        }
        return null;
    }
}

