/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.internal.monitor.LocalRecordStoreStats;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalRecordStoreStatsImpl
implements LocalRecordStoreStats,
IdentifiedDataSerializable,
Versioned {
    private static final AtomicLongFieldUpdater<LocalRecordStoreStatsImpl> HITS = AtomicLongFieldUpdater.newUpdater(LocalRecordStoreStatsImpl.class, "hits");
    private static final AtomicLongFieldUpdater<LocalRecordStoreStatsImpl> EVICTION_COUNT = AtomicLongFieldUpdater.newUpdater(LocalRecordStoreStatsImpl.class, "evictionCount");
    private static final AtomicLongFieldUpdater<LocalRecordStoreStatsImpl> EXPIRATION_COUNT = AtomicLongFieldUpdater.newUpdater(LocalRecordStoreStatsImpl.class, "expirationCount");
    private static final AtomicLongFieldUpdater<LocalRecordStoreStatsImpl> LAST_ACCESS_TIME = AtomicLongFieldUpdater.newUpdater(LocalRecordStoreStatsImpl.class, "lastAccessTime");
    private static final AtomicLongFieldUpdater<LocalRecordStoreStatsImpl> LAST_UPDATE_TIME = AtomicLongFieldUpdater.newUpdater(LocalRecordStoreStatsImpl.class, "lastUpdateTime");
    private volatile long hits;
    private volatile long lastAccessTime;
    private volatile long lastUpdateTime;
    private volatile long evictionCount;
    private volatile long expirationCount;

    public void copyFrom(LocalRecordStoreStats stats) {
        this.hits = stats.getHits();
        this.lastAccessTime = stats.getLastAccessTime();
        this.lastUpdateTime = stats.getLastUpdateTime();
        this.evictionCount = stats.getEvictionCount();
        this.expirationCount = stats.getExpirationCount();
    }

    @Override
    public long getEvictionCount() {
        return this.evictionCount;
    }

    @Override
    public long getExpirationCount() {
        return this.expirationCount;
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void setLastAccessTime(long time) {
        LAST_ACCESS_TIME.lazySet(this, Math.max(this.lastAccessTime, time));
    }

    @Override
    public void setLastUpdateTime(long time) {
        LAST_UPDATE_TIME.lazySet(this, Math.max(this.lastUpdateTime, time));
    }

    @Override
    public void increaseEvictions() {
        EVICTION_COUNT.lazySet(this, this.evictionCount + 1L);
    }

    @Override
    public void increaseExpirations() {
        EXPIRATION_COUNT.lazySet(this, this.expirationCount + 1L);
    }

    @Override
    public void increaseHits() {
        HITS.lazySet(this, this.hits + 1L);
    }

    public void reset() {
        this.hits = 0L;
        this.lastAccessTime = 0L;
        this.lastUpdateTime = 0L;
        this.evictionCount = 0L;
        this.expirationCount = 0L;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.hits);
        out.writeLong(this.lastAccessTime);
        out.writeLong(this.lastUpdateTime);
        out.writeLong(this.evictionCount);
        out.writeLong(this.expirationCount);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.hits = in.readLong();
        this.lastAccessTime = in.readLong();
        this.lastUpdateTime = in.readLong();
        this.evictionCount = in.readLong();
        this.expirationCount = in.readLong();
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 154;
    }
}

