/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="bean", description="Idempotent repository that uses Hazelcast cache to store message ids.", annotations={"interfaceName=org.apache.camel.spi.IdempotentRepository"})
@Configurer(metadataOnly=true)
public class HazelcastIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    protected boolean useLocalHzInstance;
    @Metadata(description="Name of cache to use", defaultValue="HazelcastIdempotentRepository")
    private String repositoryName;
    private IMap<String, Boolean> repo;
    @Metadata(description="To use an existing Hazelcast instance instead of local")
    private HazelcastInstance hazelcastInstance;

    public HazelcastIdempotentRepository() {
        this(null);
    }

    public HazelcastIdempotentRepository(HazelcastInstance hazelcastInstance) {
        this(hazelcastInstance, HazelcastIdempotentRepository.class.getSimpleName());
    }

    public HazelcastIdempotentRepository(HazelcastInstance hazelcastInstance, String repositoryName) {
        this.hazelcastInstance = hazelcastInstance;
        this.repositoryName = repositoryName;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.hazelcastInstance == null) {
            Config cfg = new XmlConfigBuilder().build();
            cfg.setProperty("hazelcast.version.check.enabled", "false");
            this.hazelcastInstance = Hazelcast.newHazelcastInstance(cfg);
            this.useLocalHzInstance = true;
        } else {
            ObjectHelper.notNull(this.hazelcastInstance, "hazelcastInstance");
        }
        this.repo = this.hazelcastInstance.getMap(this.repositoryName);
    }

    @Override
    protected void doStop() throws Exception {
        if (this.useLocalHzInstance) {
            this.hazelcastInstance.getLifecycleService().shutdown();
        }
    }

    @Override
    public boolean add(String key) {
        this.repo.lock(key);
        try {
            boolean bl = this.repo.putIfAbsent(key, false) == null;
            return bl;
        }
        finally {
            this.repo.unlock(key);
        }
    }

    @Override
    public boolean confirm(String key) {
        this.repo.lock(key);
        try {
            boolean bl = this.repo.replace(key, false, true);
            return bl;
        }
        finally {
            this.repo.unlock(key);
        }
    }

    @Override
    public boolean contains(String key) {
        this.repo.lock(key);
        try {
            boolean bl = this.repo.containsKey(key);
            return bl;
        }
        finally {
            this.repo.unlock(key);
        }
    }

    @Override
    public boolean remove(String key) {
        this.repo.lock(key);
        try {
            boolean bl = this.repo.remove(key) != null;
            return bl;
        }
        finally {
            this.repo.unlock(key);
        }
    }

    @Override
    public void clear() {
        this.repo.clear();
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }
}

