/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.llp.HL7Writer;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.MllpEncoder;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

abstract class HL7EncoderWriter<T extends MllpEncoder>
implements HL7Writer {
    private OutputStream out;
    private final T encoder;
    private Charset charset;
    protected boolean omitBOM;

    public HL7EncoderWriter() {
        this.encoder = this.initEncoder();
    }

    public HL7EncoderWriter(OutputStream out) throws IOException {
        this.setOutputStream(out);
        this.encoder = this.initEncoder();
    }

    public HL7EncoderWriter(OutputStream out, Charset charset, boolean omitBOM) {
        this.out = out;
        this.charset = charset;
        this.omitBOM = omitBOM;
        this.encoder = this.initEncoder();
    }

    protected abstract T initEncoder();

    @Override
    public synchronized void setOutputStream(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("OutputStream must not be null");
        }
        this.out = new BufferedOutputStream(out);
    }

    @Override
    public synchronized void writeMessage(String message) throws LLPException, IOException {
        if (message == null) {
            throw new NullPointerException("Message must not be null");
        }
        ((MllpEncoder)this.encoder).putMessage(message, this.out);
    }

    public synchronized void writeMessage(String message, String charset) throws IOException {
        if (message == null) {
            throw new NullPointerException("Message may not be null");
        }
        OutputStreamWriter writer = new OutputStreamWriter(this.out, charset);
        writer.write(11);
        writer.write(message);
        writer.write(28);
        writer.write(13);
        writer.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    protected Charset getCharset() {
        if (this.charset == null) {
            String charsetString = System.getProperty("ca.uhn.hl7v2.llp.charset", "US-ASCII");
            this.charset = charsetString.equals("default") ? Charset.defaultCharset() : Charset.forName(charsetString);
        }
        return this.charset;
    }
}

