/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.protocol.JMSDestination;
import ca.uhn.hl7v2.protocol.TransportException;
import ca.uhn.hl7v2.protocol.TransportLayer;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.AbstractTransport;
import ca.uhn.hl7v2.protocol.impl.TransportableImpl;
import ca.uhn.hl7v2.protocol.impl.URLTransport;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSTransport
extends AbstractTransport
implements TransportLayer {
    private static final Logger log = LoggerFactory.getLogger(URLTransport.class);
    public static final String INBOUND_DESTINATION_NAME_KEY = "INBOUND_DESTINATION_NAME";
    public static final String INBOUND_CLIENT_ID_KEY = "INBOUND_CLIENT_ID";
    public static final String INBOUND_CONNECTION_METADATA_KEY = "INBOUND_CONNECTION_METADATA";
    public static final String OUTBOUND_DESTINATION_NAME_KEY = "OUTBOUND_DESTINATION_NAME";
    public static final String OUTBOUND_CLIENT_ID_KEY = "OUTBOUND_CLIENT_ID";
    public static final String OUTBOUND_CONNECTION_METADATA_KEY = "OUTBOUND_CONNECTION_METADATA";
    private JMSDestination myInbound;
    private JMSDestination myOutbound;
    private Map<String, Object> myMetadata;

    public JMSTransport(JMSDestination theInboundDestination, JMSDestination theOutboundDestination) {
        this.myInbound = theInboundDestination;
        this.myOutbound = theOutboundDestination;
    }

    public JMSTransport() {
        this.myMetadata = this.makeMetadata();
    }

    private Map<String, Object> makeMetadata() {
        HashMap<String, Object> md = new HashMap<String, Object>();
        try {
            md.put(INBOUND_CLIENT_ID_KEY, this.myInbound.getConnection().getClientID());
            md.put(INBOUND_CONNECTION_METADATA_KEY, this.myInbound.getConnection().getMetaData());
            md.put(INBOUND_DESTINATION_NAME_KEY, this.myInbound.getName());
            md.put(OUTBOUND_CLIENT_ID_KEY, this.myOutbound.getConnection().getClientID());
            md.put(OUTBOUND_CONNECTION_METADATA_KEY, this.myOutbound.getConnection().getMetaData());
            md.put(OUTBOUND_DESTINATION_NAME_KEY, this.myOutbound.getName());
        }
        catch (JMSException e) {
            log.error("Error setting JMSTransport metadata", (Throwable)e);
        }
        return md;
    }

    @Override
    public void doSend(Transportable theMessage) throws TransportException {
        try {
            Message message = this.toMessage(theMessage);
            this.myOutbound.send(message);
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
    }

    protected Message toMessage(Transportable theSource) throws TransportException {
        TextMessage message;
        try {
            message = this.myOutbound.createMessage();
            if (message == null) {
                throw new TransportException("This implementation expects getMessage() to return  a TextMessage.  Override this method if another message type is to be used");
            }
            message.setText(theSource.getMessage());
            for (String key : theSource.getMetadata().keySet()) {
                Object val = theSource.getMetadata().get(key);
                message.setObjectProperty(key.toString(), val);
            }
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
        return message;
    }

    protected Transportable toTransportable(Message theMessage) throws TransportException {
        TransportableImpl result;
        if (!(theMessage instanceof TextMessage)) {
            throw new TransportException("This implementation expects getMessage() to return  a TextMessage.  Override this method if another message type is to be used");
        }
        try {
            String text = ((TextMessage)theMessage).getText();
            result = new TransportableImpl(text);
            result.getMetadata().putAll(this.getCommonMetadata());
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
        return result;
    }

    @Override
    public Transportable doReceive() throws TransportException {
        Transportable result;
        try {
            Message message = this.myInbound.receive();
            result = this.toTransportable(message);
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
        return result;
    }

    @Override
    public Map<String, Object> getCommonMetadata() {
        return this.myMetadata;
    }

    @Override
    public void doConnect() throws TransportException {
        try {
            this.myInbound.connect();
            if (this.myInbound != this.myOutbound) {
                this.myOutbound.connect();
            }
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public void doDisconnect() throws TransportException {
        try {
            this.myInbound.disconnect();
            if (this.myInbound != this.myOutbound) {
                this.myOutbound.disconnect();
            }
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
    }
}

