/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.validation.ValidationContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.hl7.AckExpression;
import org.apache.camel.component.hl7.ValidationContextPredicate;
import org.apache.camel.model.language.Hl7TerserExpression;
import org.apache.camel.support.ExpressionAdapter;

public final class HL7 {
    private HL7() {
    }

    public static ValueBuilder hl7terser(String expression) {
        return new ValueBuilder(new Hl7TerserExpression(expression));
    }

    public static ValueBuilder ack() {
        return new ValueBuilder(new AckExpression());
    }

    public static ValueBuilder ack(AcknowledgmentCode code) {
        return new ValueBuilder(new AckExpression(code));
    }

    public static ValueBuilder convertLFToCR() {
        return new ValueBuilder(new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String s = exchange.getIn().getBody(String.class);
                return s != null ? s.replace('\n', '\r') : null;
            }
        });
    }

    public static ValueBuilder ack(AcknowledgmentCode code, String errorMessage, ErrorCode errorCode) {
        return new ValueBuilder(new AckExpression(code, errorMessage, errorCode));
    }

    public static Predicate messageConforms() {
        return new ValidationContextPredicate();
    }

    public static Predicate messageConformsTo(HapiContext hapiContext) {
        return new ValidationContextPredicate(hapiContext);
    }

    public static Predicate messageConformsTo(ValidationContext validationContext) {
        return new ValidationContextPredicate(validationContext);
    }

    public static Predicate messageConformsTo(Expression expression) {
        return new ValidationContextPredicate(expression);
    }
}

