/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.model.GenericMessage;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.hl7.HL7GenericMessageConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class HL7GenericMessageConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.class, byte[].class, false, (type, exchange, value) -> HL7GenericMessageConverter.toGenericMessage((byte[])value, exchange));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.class, String.class, false, (type, exchange, value) -> HL7GenericMessageConverter.toGenericMessage((String)value));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V21.class, byte[].class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV21GenericMessage((byte[])value, exchange));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V21.class, String.class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV21GenericMessage((String)value));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V22.class, byte[].class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV22GenericMessage((byte[])value, exchange));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V22.class, String.class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV22GenericMessage((String)value));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V23.class, byte[].class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV23GenericMessage((byte[])value, exchange));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V23.class, String.class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV23GenericMessage((String)value));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V231.class, byte[].class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV231GenericMessage((byte[])value, exchange));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V231.class, String.class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV231GenericMessage((String)value));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V24.class, byte[].class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV24GenericMessage((byte[])value, exchange));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V24.class, String.class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV24GenericMessage((String)value));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V25.class, byte[].class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV25GenericMessage((byte[])value, exchange));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V25.class, String.class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV25GenericMessage((String)value));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V251.class, byte[].class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV251GenericMessage((byte[])value, exchange));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V251.class, String.class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV251GenericMessage((String)value));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V26.class, byte[].class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV26GenericMessage((byte[])value, exchange));
        HL7GenericMessageConverterLoader.addTypeConverter(registry, GenericMessage.V26.class, String.class, false, (type, exchange, value) -> HL7GenericMessageConverter.toV26GenericMessage((String)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }
}

