/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.http.HttpConstants;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpEntityConverter;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.component.http.helper.HttpMethodHelper;
import org.apache.camel.http.base.HttpOperationFailedException;
import org.apache.camel.http.base.cookie.CookieHandler;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpProtocolHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.GZIPHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.support.http.HttpUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.io.entity.NullEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(HttpProducer.class);
    private static final Integer OK_RESPONSE_CODE = 200;
    private static final int BUFFER_SIZE = 2048;
    private HttpClient httpClient;
    private final HttpContext httpContext;
    private final boolean throwException;
    private final boolean transferException;
    private final HeaderFilterStrategy httpProtocolHeaderFilterStrategy = new HttpProtocolHeaderFilterStrategy();
    private int minOkRange;
    private int maxOkRange;
    private String defaultUrl;
    private URI defaultUri;
    private HttpHost defaultHttpHost;

    public HttpProducer(HttpEndpoint endpoint) {
        super(endpoint);
        this.httpClient = endpoint.getHttpClient();
        this.httpContext = endpoint.getHttpContext();
        this.throwException = endpoint.isThrowExceptionOnFailure();
        this.transferException = endpoint.isTransferException();
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        String range = this.getEndpoint().getOkStatusCodeRange();
        this.parseStatusRange(range);
        String url = this.getEndpoint().getHttpUri().toASCIIString();
        url = UnsafeUriCharactersEncoder.encodeHttpURI(url);
        URI uri = new URI(url);
        String queryString = this.getEndpoint().getHttpUri().getRawQuery();
        if (queryString == null) {
            queryString = uri.getRawQuery();
        }
        if (queryString != null) {
            queryString = UnsafeUriCharactersEncoder.encodeHttpURI(queryString);
            uri = URISupport.createURIWithQuery(uri, queryString);
        }
        this.defaultUri = uri;
        this.defaultUrl = uri.toASCIIString();
        this.defaultHttpHost = URIUtils.extractHost(uri);
    }

    private void parseStatusRange(String range) {
        if (!range.contains(",") && !HttpUtil.parseStatusRange(range, this::setRanges)) {
            this.maxOkRange = this.minOkRange = Integer.parseInt(range);
        }
    }

    private void setRanges(int minOkRange, int maxOkRange) {
        this.minOkRange = minOkRange;
        this.maxOkRange = maxOkRange;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String hostHeader;
        String key;
        boolean cookies;
        boolean bl = cookies = !this.getEndpoint().getComponent().isCookieManagementDisabled();
        if (cookies && this.getEndpoint().isClearExpiredCookies() && !this.getEndpoint().isBridgeEndpoint()) {
            this.getEndpoint().getCookieStore().clearExpired(new Date());
        }
        Map<String, Object> skipRequestHeaders = null;
        if (this.getEndpoint().isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
            String queryString = exchange.getIn().getHeader("CamelHttpQuery", String.class);
            if (queryString != null) {
                skipRequestHeaders = URISupport.parseQuery(queryString, false, true);
            }
        }
        HttpUriRequest httpRequest = this.createMethod(exchange);
        HttpHost httpHost = this.createHost(httpRequest);
        Message in = exchange.getIn();
        String httpProtocolVersion = in.getHeader("CamelHttpProtocolVersion", String.class);
        if (httpProtocolVersion != null) {
            int[] version = HttpHelper.parserHttpVersion(httpProtocolVersion);
            httpRequest.setVersion(new HttpVersion(version[0], version[1]));
        }
        HeaderFilterStrategy strategy = this.getEndpoint().getHeaderFilterStrategy();
        if (!this.getEndpoint().isSkipRequestHeaders() && strategy != null) {
            TypeConverter tc = exchange.getContext().getTypeConverter();
            for (Map.Entry<String, Object> throwable : in.getHeaders().entrySet()) {
                Object headerValue;
                key = throwable.getKey();
                if (skipRequestHeaders != null && skipRequestHeaders.containsKey(key) || (headerValue = throwable.getValue()) == null) continue;
                if (headerValue instanceof String || headerValue instanceof Integer || headerValue instanceof Long || headerValue instanceof Boolean || headerValue instanceof Date) {
                    String value = headerValue.toString();
                    if (strategy.applyFilterToCamelHeaders(key, value, exchange)) continue;
                    httpRequest.addHeader(key, value);
                    continue;
                }
                Iterator<?> it = ObjectHelper.createIterator(headerValue, null, true);
                HttpUtil.applyHeader(strategy, exchange, it, tc, key, (multiValues, prev) -> HttpProducer.applyHeader(httpRequest, key, multiValues, prev));
            }
        }
        if (this.getEndpoint().getCookieHandler() != null) {
            Map<String, List<String>> cookieHeaders = this.getEndpoint().getCookieHandler().loadCookies(exchange, httpRequest.getUri());
            for (Map.Entry<String, Object> entry : cookieHeaders.entrySet()) {
                key = entry.getKey();
                if (((List)entry.getValue()).isEmpty()) continue;
                httpRequest.addHeader(key, String.join((CharSequence)";", (Iterable)entry.getValue()));
            }
        }
        if (this.getEndpoint().getCustomHostHeader() != null) {
            httpRequest.setHeader("Host", this.getEndpoint().getCustomHostHeader());
        }
        if (this.getEndpoint().isPreserveHostHeader() && (hostHeader = exchange.getIn().getHeader("Host", String.class)) != null) {
            httpRequest.setHeader("Host", hostHeader);
        }
        if (this.getEndpoint().isConnectionClose()) {
            httpRequest.addHeader("Connection", "close");
        }
        try {
            this.executeMethod(httpHost, httpRequest, httpResponse -> {
                block33: {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Executing http {} method: {}", (Object)httpRequest.getMethod(), (Object)httpRequest.getUri());
                        }
                        int responseCode = httpResponse.getCode();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Http responseCode: {}", (Object)responseCode);
                        }
                        if (!this.throwException) {
                            this.populateResponse(exchange, httpRequest, httpResponse, strategy, responseCode);
                        } else {
                            boolean ok = this.minOkRange > 0 ? responseCode >= this.minOkRange && responseCode <= this.maxOkRange : HttpHelper.isStatusCodeOk(responseCode, this.getEndpoint().getOkStatusCodeRange());
                            if (!ok) throw this.populateHttpOperationFailedException(exchange, httpRequest, httpResponse, responseCode);
                            this.populateResponse(exchange, httpRequest, httpResponse, strategy, responseCode);
                        }
                        if (httpResponse == null) break block33;
                    }
                    catch (IOException | RuntimeCamelException | HttpException e) {
                        try {
                            throw e;
                            catch (Exception e2) {
                                throw new RuntimeCamelException(e2);
                            }
                        }
                        catch (Throwable throwable) {
                            if (httpResponse != null && this.getEndpoint().isDisableStreamCache()) {
                                exchange.getExchangeExtension().addOnCompletion(new SynchronizationAdapter(httpResponse, httpRequest){
                                    final /* synthetic */ ClassicHttpResponse val$httpResponse;
                                    final /* synthetic */ HttpUriRequest val$httpRequest;
                                    {
                                        this.val$httpResponse = classicHttpResponse;
                                        this.val$httpRequest = httpUriRequest;
                                    }

                                    @Override
                                    public void onDone(Exchange exchange1) {
                                        try {
                                            EntityUtils.consume(this.val$httpResponse.getEntity());
                                        }
                                        catch (Exception exception) {
                                        }
                                        finally {
                                            try {
                                                EntityUtils.consume(this.val$httpRequest.getEntity());
                                            }
                                            catch (Exception exception) {}
                                        }
                                    }
                                });
                                throw throwable;
                            }
                            if (httpResponse == null) throw throwable;
                            try {
                                EntityUtils.consume(httpResponse.getEntity());
                                throw throwable;
                            }
                            catch (Exception exception) {
                                throw throwable;
                            }
                            finally {
                                try {
                                    EntityUtils.consume(httpRequest.getEntity());
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    if (this.getEndpoint().isDisableStreamCache()) {
                        exchange.getExchangeExtension().addOnCompletion(new /* invalid duplicate definition of identical inner class */);
                        return null;
                    }
                }
                if (httpResponse == null) return null;
                try {
                    EntityUtils.consume(httpResponse.getEntity());
                    return null;
                }
                catch (Exception responseCode) {
                    return null;
                }
                finally {
                    try {
                        EntityUtils.consume(httpRequest.getEntity());
                    }
                    catch (Exception responseCode) {}
                }
            });
        }
        catch (RuntimeCamelException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof Exception) {
                Exception ex = (Exception)throwable;
                throw ex;
            }
            throw e;
        }
    }

    private static void applyHeader(HttpUriRequest httpRequest, String key, List<String> multiValues, String prev) {
        if (multiValues != null) {
            String s = multiValues.size() > 1 ? multiValues.toString() : multiValues.get(0);
            httpRequest.addHeader(key, s);
        } else if (prev != null) {
            httpRequest.addHeader(key, prev);
        }
    }

    @Override
    public HttpEndpoint getEndpoint() {
        return (HttpEndpoint)super.getEndpoint();
    }

    protected void populateResponse(Exchange exchange, HttpUriRequest httpRequest, ClassicHttpResponse httpResponse, HeaderFilterStrategy strategy, int responseCode) throws IOException, ClassNotFoundException {
        Object response = this.extractResponseBody(httpResponse, exchange, this.getEndpoint().isIgnoreResponseBody());
        Message answer = HttpProducer.createResponseMessage(exchange, httpResponse, responseCode);
        answer.setBody(response);
        if (!this.getEndpoint().isSkipResponseHeaders()) {
            HashMap<String, List<String>> cookieHeaders = null;
            CookieHandler cookieHandler = this.getEndpoint().getCookieHandler();
            if (cookieHandler != null) {
                cookieHeaders = new HashMap<String, List<String>>();
            }
            boolean found = false;
            Iterator<Header> it = httpResponse.headerIterator();
            while (it.hasNext()) {
                Header header = it.next();
                String name = header.getName();
                String value = header.getValue();
                if (cookieHeaders != null) {
                    cookieHeaders.computeIfAbsent(name, k -> new ArrayList()).add(value);
                }
                if (!found && name.equalsIgnoreCase("content-type")) {
                    name = "Content-Type";
                    exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)IOHelper.getCharsetNameFromContentType(value));
                    found = true;
                }
                Object extracted = HttpHelper.extractHttpParameterValue(value);
                if (strategy == null || strategy.applyFilterToExternalHeaders(name, extracted, exchange)) continue;
                HttpHelper.appendHeader(answer.getHeaders(), name, extracted);
            }
            if (cookieHandler != null) {
                try {
                    cookieHandler.storeCookies(exchange, httpRequest.getUri(), cookieHeaders);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeCamelException(e);
                }
            }
        }
        if (this.getEndpoint().isCopyHeaders()) {
            MessageHelper.copyHeaders(exchange.getIn(), answer, this.httpProtocolHeaderFilterStrategy, false);
        }
    }

    private static Message createResponseMessage(Exchange exchange, ClassicHttpResponse httpResponse, int responseCode) {
        Message answer = exchange.getOut();
        if (responseCode == 200) {
            answer.setHeader("CamelHttpResponseCode", OK_RESPONSE_CODE);
        } else {
            answer.setHeader("CamelHttpResponseCode", responseCode);
        }
        if (httpResponse.getReasonPhrase() != null) {
            answer.setHeader("CamelHttpResponseText", httpResponse.getReasonPhrase());
        }
        return answer;
    }

    protected Exception populateHttpOperationFailedException(Exchange exchange, HttpUriRequest httpRequest, ClassicHttpResponse httpResponse, int responseCode) throws IOException, ClassNotFoundException {
        HttpOperationFailedException answer;
        String statusText = httpResponse.getReasonPhrase() != null ? httpResponse.getReasonPhrase() : null;
        Map<String, String> headers = HttpProducer.extractResponseHeaders(httpResponse.getHeaders());
        CookieHandler cookieHandler = this.getEndpoint().getCookieHandler();
        if (cookieHandler != null) {
            HashMap<String, List<String>> m = new HashMap<String, List<String>>();
            for (Map.Entry<String, String> e : headers.entrySet()) {
                m.put(e.getKey(), Collections.singletonList(e.getValue()));
            }
            try {
                cookieHandler.storeCookies(exchange, httpRequest.getUri(), m);
            }
            catch (URISyntaxException e) {
                throw new RuntimeCamelException(e);
            }
        }
        Object responseBody = this.extractResponseBody(httpResponse, exchange, this.getEndpoint().isIgnoreResponseBody());
        if (this.transferException && responseBody instanceof Exception) {
            Exception ex = (Exception)responseBody;
            return ex;
        }
        String copy = null;
        if (responseBody != null) {
            copy = exchange.getContext().getTypeConverter().convertTo(String.class, exchange, responseBody);
        }
        Header locationHeader = httpResponse.getFirstHeader("location");
        try {
            String uri = httpRequest.getUri().toString();
            answer = locationHeader != null && responseCode >= 300 && responseCode < 400 ? new HttpOperationFailedException(uri, responseCode, statusText, locationHeader.getValue(), headers, copy) : new HttpOperationFailedException(uri, responseCode, statusText, null, headers, copy);
        }
        catch (URISyntaxException e) {
            throw new RuntimeCamelException(e);
        }
        return answer;
    }

    protected <T> T executeMethod(HttpHost httpHost, HttpUriRequest httpRequest, HttpClientResponseHandler<T> handler) throws IOException, HttpException {
        HttpContext localContext = this.httpContext != null ? new BasicHttpContext(this.httpContext) : HttpClientContext.create();
        ClassicHttpResponse res = this.httpClient.executeOpen(httpHost, httpRequest, localContext);
        return handler.handleResponse(res);
    }

    protected static Map<String, String> extractResponseHeaders(Header[] responseHeaders) {
        if (responseHeaders == null || responseHeaders.length == 0) {
            return Map.of();
        }
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Header header : responseHeaders) {
            answer.put(header.getName(), header.getValue());
        }
        return answer;
    }

    protected Object extractResponseBody(ClassicHttpResponse httpResponse, Exchange exchange, boolean ignoreResponseBody) throws IOException, ClassNotFoundException {
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return null;
        }
        InputStream is = entity.getContent();
        if (is == null) {
            return null;
        }
        Header header = httpResponse.getFirstHeader("Content-Encoding");
        String contentEncoding = header != null ? header.getValue() : null;
        boolean gzipEncoding = exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class);
        if (!gzipEncoding) {
            is = GZIPHelper.uncompressGzip(contentEncoding, is);
        }
        String contentType = null;
        header = httpResponse.getFirstHeader("content-type");
        if (header != null) {
            contentType = header.getValue();
            HttpHelper.setCharsetFromContentType(contentType, exchange);
        }
        if (ignoreResponseBody) {
            return null;
        }
        if (contentType != null && contentType.equals("application/x-java-serialized-object")) {
            if (this.getEndpoint().getComponent().isAllowJavaSerializedObject() || this.getEndpoint().isTransferException()) {
                return HttpHelper.deserializeJavaObjectFromStream(is, exchange.getContext());
            }
            return null;
        }
        if (entity.isStreaming()) {
            long len;
            if (this.getEndpoint().isDisableStreamCache()) {
                return is;
            }
            int max = this.getEndpoint().getComponent().getResponsePayloadStreamingThreshold();
            if (max > 0 && (len = entity.getContentLength()) > 0L && len <= (long)max) {
                int read;
                int i = (int)len;
                byte[] arr = new byte[i];
                int offset = 0;
                for (int remain = i; (read = is.read(arr, offset, remain)) > 0 && remain > 0; remain -= read) {
                    offset += read;
                }
                IOHelper.close((Closeable)is);
                return arr;
            }
            return this.doExtractResponseBodyAsStream(is, exchange);
        }
        return is;
    }

    private Object doExtractResponseBodyAsStream(InputStream is, Exchange exchange) throws IOException {
        OutputStreamBuilder osb = OutputStreamBuilder.withExchange(exchange);
        IOHelper.copy(is, osb);
        return osb.build();
    }

    protected HttpHost createHost(HttpUriRequest httpRequest) {
        try {
            URI uri = httpRequest.getUri();
            if (uri.equals(this.defaultUri)) {
                return this.defaultHttpHost;
            }
            return HttpHost.create(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeCamelException(e);
        }
    }

    protected HttpUriRequest createMethod(Exchange exchange) throws Exception {
        if (this.defaultUri == null || this.defaultUrl == null) {
            throw new IllegalArgumentException("Producer must be started");
        }
        String url = this.defaultUrl;
        URI uri = this.defaultUri;
        boolean create = this.isCreateNewURL(exchange);
        if (create) {
            url = HttpHelper.createURL(exchange, this.getEndpoint());
            uri = HttpHelper.createURI(exchange, url, this.getEndpoint());
            url = uri.toASCIIString();
        }
        HttpMethods methodToUse = HttpMethodHelper.createMethod(exchange, this.getEndpoint());
        HttpUriRequest method = methodToUse.createMethod(uri);
        if (this.getEndpoint().isDeleteWithBody() && "DELETE".equals(method.getMethod()) || this.getEndpoint().isGetWithBody() && "GET".equals(method.getMethod())) {
            method.setEntity(this.createRequestEntity(exchange));
        }
        LOG.trace("Using URL: {} with method: {}", (Object)url, (Object)method);
        if (methodToUse.isEntityEnclosing()) {
            HttpEntity requestEntity = this.createRequestEntity(exchange);
            method.setEntity(requestEntity);
            if (requestEntity != null && requestEntity.getContentType() == null) {
                LOG.debug("No Content-Type provided for URL: {} with exchange: {}", (Object)url, (Object)exchange);
            }
        }
        if (uri.getScheme() == null || uri.getHost() == null) {
            throw new IllegalArgumentException("Invalid url: " + url + ". If you are forwarding/bridging http endpoints, then enable the bridgeEndpoint option on the endpoint: " + String.valueOf(this.getEndpoint()));
        }
        return method;
    }

    private boolean isCreateNewURL(Exchange exchange) {
        boolean create = false;
        Message in = exchange.getIn();
        if (in.getHeader("CamelRestHttpUri") != null) {
            create = true;
        } else if (in.getHeader("CamelHttpUri") != null && !this.getEndpoint().isBridgeEndpoint()) {
            create = true;
        } else if (in.getHeader("CamelHttpPath") != null) {
            create = true;
        } else if (in.getHeader("CamelRestHttpQuery") != null) {
            create = true;
        } else if (in.getHeader("CamelHttpRawQuery") != null) {
            create = true;
        } else if (in.getHeader("CamelHttpQuery") != null) {
            create = true;
        }
        return create;
    }

    protected HttpEntity createRequestEntity(Exchange exchange) throws CamelExchangeException {
        String content;
        HttpEntity answer = null;
        Message in = exchange.getIn();
        Object body = in.getBody();
        try {
            if (body == null) {
                return NullEntity.INSTANCE;
            }
            if (body instanceof HttpEntity) {
                HttpEntity entity;
                answer = entity = (HttpEntity)body;
            } else if (body instanceof byte[]) {
                byte[] bytes = (byte[])body;
                answer = HttpEntityConverter.toHttpEntity(bytes, exchange);
            } else if (body instanceof InputStream) {
                InputStream is = (InputStream)body;
                answer = HttpEntityConverter.toHttpEntity(is, exchange);
            } else if (body instanceof String) {
                content = (String)body;
                answer = HttpEntityConverter.toHttpEntity(content, exchange);
            }
        }
        catch (Exception e) {
            throw new CamelExchangeException("Error creating RequestEntity from message body", exchange, e);
        }
        if (answer == null) {
            try {
                Object data = in.getBody();
                if (data != null) {
                    String contentTypeString = ExchangeHelper.getContentType(exchange);
                    ContentType contentType = null;
                    if (contentTypeString != null) {
                        contentType = contentTypeString.contains("charset") || contentTypeString.contains(";") ? ContentType.parse(contentTypeString) : ContentType.create(contentTypeString);
                    }
                    if (contentTypeString != null && "application/x-java-serialized-object".equals(contentTypeString)) {
                        if (!this.getEndpoint().getComponent().isAllowJavaSerializedObject()) {
                            throw new CamelExchangeException("Content-type application/x-java-serialized-object is not allowed", exchange);
                        }
                        Serializable obj = in.getMandatoryBody(Serializable.class);
                        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                            HttpHelper.writeObjectToStream(bos, obj);
                            answer = new ByteArrayEntity(bos.toByteArray(), HttpConstants.JAVA_SERIALIZED_OBJECT);
                        }
                    } else if (data instanceof File || data instanceof GenericFile) {
                        File file = in.getBody(File.class);
                        if (file != null) {
                            answer = new FileEntity(file, contentType);
                        }
                    } else if (data instanceof String) {
                        Charset cs;
                        content = (String)data;
                        String charset = ExchangeHelper.getCharsetName(exchange, false);
                        if (charset == null && contentType != null && (cs = contentType.getCharset()) != null) {
                            charset = cs.name();
                        }
                        if (contentType != null && contentType.getCharset() == null && charset != null) {
                            contentType = ContentType.parse(String.valueOf(contentType) + ";charset=" + charset);
                        }
                        answer = new StringEntity(content, contentType, false);
                    }
                    if (answer == null) {
                        InputStream is = in.getMandatoryBody(InputStream.class);
                        answer = new InputStreamEntity(is, -1L, contentType);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new CamelExchangeException("Error creating RequestEntity from message body", exchange, e);
            }
            catch (IOException e) {
                throw new CamelExchangeException("Error serializing message body", exchange, e);
            }
        }
        return answer;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

