/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import org.apache.camel.spi.Metadata;
import org.apache.hc.core5.http.ContentType;

public final class HttpConstants {
    public static final String CONTENT_TYPE_JAVA_SERIALIZED_OBJECT = "application/x-java-serialized-object";
    public static final ContentType JAVA_SERIALIZED_OBJECT = ContentType.create("application/x-java-serialized-object");
    public static final String CONTENT_TYPE_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    @Metadata(description="The HTTP content encoding. Is set on both the IN and OUT message to\nprovide a content encoding, such as `gzip`.", javaType="String")
    public static final String CONTENT_ENCODING = "Content-Encoding";
    @Metadata(description="The HTTP response code from the external server. Is 200 for OK.", javaType="int")
    public static final String HTTP_RESPONSE_CODE = "CamelHttpResponseCode";
    @Metadata(description="The HTTP response text from the external server.", javaType="String")
    public static final String HTTP_RESPONSE_TEXT = "CamelHttpResponseText";
    @Metadata(label="producer", description="URI parameters. Will override existing URI parameters set directly on\nthe endpoint.", javaType="String")
    public static final String HTTP_QUERY = "CamelHttpQuery";
    @Metadata(label="producer", description="The version of the http protocol used.", javaType="String")
    public static final String HTTP_PROTOCOL_VERSION = "CamelHttpProtocolVersion";
    @Metadata(label="producer", description="The target host.", javaType="String")
    public static final String HTTP_HEADER_HOST = "Host";
    @Metadata(label="producer", description="The rest http URI.", javaType="String")
    public static final String REST_HTTP_URI = "CamelRestHttpUri";
    @Metadata(label="producer", description="URI to call. Will override existing URI set directly on the endpoint.\nThis uri is the uri of the http server to call. Its not the same as the\nCamel endpoint uri, where you can configure endpoint options such as\nsecurity etc. This header does not support that, its only the uri of the\nhttp server.", javaType="String")
    public static final String HTTP_URI = "CamelHttpUri";
    @Metadata(label="producer", description="Request URI's path, the header will be used to build the request URI\nwith the HTTP_URI.", javaType="String")
    public static final String HTTP_PATH = "CamelHttpPath";
    @Metadata(label="producer", description="The rest http query.", javaType="String")
    public static final String REST_HTTP_QUERY = "CamelRestHttpQuery";
    @Metadata(label="producer", description="The http raw query.", javaType="String")
    public static final String HTTP_RAW_QUERY = "CamelHttpRawQuery";
    @Metadata(label="producer", description="The http method to use.", javaType="org.apache.camel.component.http.HttpMethods")
    public static final String HTTP_METHOD = "CamelHttpMethod";
    @Metadata(description="The character encoding.", javaType="String")
    public static final String HTTP_CHARACTER_ENCODING = "CamelHttpCharacterEncoding";
    @Metadata(description="The HTTP content type. Is set on both the IN and OUT message to provide\na content type, such as `text/html`.", javaType="String")
    public static final String CONTENT_TYPE = "Content-Type";

    private HttpConstants() {
    }
}

