/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.base;

import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.support.http.HttpUtil;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public final class HttpHelper {
    private HttpHelper() {
    }

    public static boolean isSecureConnection(String uri) {
        return uri.startsWith("https");
    }

    public static int[] parserHttpVersion(String s) throws ProtocolException {
        int minor;
        int major;
        if (s == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        if (!s.startsWith("HTTP/")) {
            throw new ProtocolException("Invalid HTTP version string: " + s);
        }
        int i1 = "HTTP/".length();
        int i2 = s.indexOf(46, i1);
        if (i2 == -1) {
            throw new ProtocolException("Invalid HTTP version number: " + s);
        }
        try {
            major = Integer.parseInt(s.substring(i1, i2));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Invalid HTTP major version number: " + s);
        }
        i1 = i2 + 1;
        i2 = s.length();
        try {
            minor = Integer.parseInt(s.substring(i1, i2));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Invalid HTTP minor version number: " + s);
        }
        return new int[]{major, minor};
    }

    public static void setCharsetFromContentType(String contentType, Exchange exchange) {
        String charset;
        if (contentType != null && (charset = IOHelper.getCharsetNameFromContentType(contentType)) != null) {
            exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)charset);
        }
    }

    public static void appendHeader(Map<String, Object> headers, String key, Object value) {
        CollectionHelper.appendEntry(headers, key, value);
    }

    public static Object extractHttpParameterValue(String value) {
        if (ObjectHelper.isEmpty(value)) {
            return value;
        }
        String trimmed = value.trim();
        if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
            String[] values;
            trimmed = trimmed.substring(1, trimmed.length() - 1);
            ArrayList<String> list = new ArrayList<String>();
            for (String s : values = trimmed.split(",")) {
                list.add(s.trim());
            }
            return list;
        }
        return value;
    }

    public static boolean isStatusCodeOk(int statusCode, String okStatusCodeRange) {
        return HttpUtil.isStatusCodeOk(statusCode, okStatusCodeRange);
    }

    public static void evalPlaceholders(Map<String, Object> headersMap, String path, String consumerPath) {
        HttpHelper.evalPlaceholders(headersMap::put, path, consumerPath);
    }

    public static void evalPlaceholders(BiConsumer<String, Object> keyPairConsumer, String path, String consumerPath) {
        String[] paths = path.split("/");
        String[] consumerPaths = consumerPath.split("/");
        for (int i = 0; i < consumerPaths.length && paths.length >= i; ++i) {
            String p1 = consumerPaths[i];
            if (!p1.startsWith("{") || !p1.endsWith("}")) continue;
            String key = p1.substring(1, p1.length() - 1);
            String value = paths[i];
            if (value == null) continue;
            keyPairConsumer.accept(key, value);
        }
    }
}

