/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.Message;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.http.common.HttpConverter;
import org.apache.camel.http.common.HttpMessage;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class HttpConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        HttpConverterLoader.addTypeConverter(registry, ServletInputStream.class, HttpMessage.class, false, (type, exchange, value) -> HttpConverter.toServletInputStream((HttpMessage)value));
        HttpConverterLoader.addTypeConverter(registry, HttpServletRequest.class, Message.class, false, (type, exchange, value) -> HttpConverter.toServletRequest((Message)value));
        HttpConverterLoader.addTypeConverter(registry, HttpServletResponse.class, Message.class, false, (type, exchange, value) -> HttpConverter.toServletResponse((Message)value));
        HttpConverterLoader.addTypeConverter(registry, BufferedReader.class, HttpMessage.class, false, (type, exchange, value) -> HttpConverter.toReader((HttpMessage)value));
        HttpConverterLoader.addTypeConverter(registry, InputStream.class, HttpServletRequest.class, false, (type, exchange, value) -> HttpConverter.toInputStream((HttpServletRequest)value, exchange));
        HttpConverterLoader.addTypeConverter(registry, InputStream.class, HttpMessage.class, false, (type, exchange, value) -> HttpConverter.toInputStream((HttpMessage)value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }
}

