/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sm4;

import javax.crypto.BadPaddingException;
import org.openeuler.sm4.SM4Util;

public class SM4Padding {
    String padding = "PKCS5PADDING";

    public String getPadding() {
        return this.padding;
    }

    public void setPadding(String padding) {
        this.padding = padding;
    }

    public byte[] fill(byte[] input) {
        int need = 16 - input.length % 16;
        byte[] output = new byte[input.length + need];
        SM4Util.copyArray(input, 0, input.length, output, 0);
        for (int i = input.length; i < input.length + need; ++i) {
            output[i] = (byte)need;
        }
        return output;
    }

    public byte[] fill(byte[] input, int offset, int len) {
        int need = 16 - len % 16;
        byte[] output = new byte[len + need];
        SM4Util.copyArray(input, offset, len, output, 0);
        for (int i = len; i < output.length; ++i) {
            output[i] = (byte)need;
        }
        return output;
    }

    public byte[] recover(byte[] input) throws BadPaddingException {
        if (!this.isFilled(input)) {
            throw new BadPaddingException();
        }
        byte n = input[input.length - 1];
        byte[] output = new byte[input.length - n];
        SM4Util.copyArray(input, 0, output.length, output, 0);
        return output;
    }

    public boolean isFilled(byte[] input) {
        byte n = input[input.length - 1];
        for (int i = input.length - 1; i >= input.length - n; --i) {
            if (input[i] == (byte)n) continue;
            return false;
        }
        return true;
    }
}

