/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.ssl;

import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.utils.RandomUtils;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.openeuler.BGMProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLSocketFactory {
    private static final Logger logger = LoggerFactory.getLogger(GMSSLSocketFactory.class);
    private static final BGMProvider BGM_PROVIDER = new BGMProvider();
    private static final X509TrustManager TRUST_MANAGER = GMSSLSocketFactory.createX509TrustManager();

    private static X509TrustManager createX509TrustManager() {
        TrustManagerFactory trustManagerFactory;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm(), BGM_PROVIDER);
            trustManagerFactory.init((KeyStore)null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            logger.error("Unable to retrieve default TrustManagerFactory", (Throwable)e);
            throw new SdkException("Unable to retrieve default TrustManagerFactory", e);
        }
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        logger.error("No X509TrustManager found");
        throw new SdkException("No X509TrustManager found");
    }

    public static SSLContext getSSLContext() {
        return GMSSLSocketFactory.getSSLContext(RandomUtils.getDefaultSecureRandom());
    }

    public static SSLContext getSSLContext(SecureRandom secureRandom) {
        try {
            SSLContext sslContext = SSLContext.getInstance("GMTLS", "BGMProvider");
            sslContext.init(null, new TrustManager[]{TRUST_MANAGER}, secureRandom);
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Init SSL Context Error", (Throwable)e);
            throw new SdkException("Init SSL Context Error", e);
        }
        catch (NoSuchProviderException e) {
            logger.error("Init SSL Provider Error", (Throwable)e);
            throw new SdkException("Init SSL Provider Error", e);
        }
        catch (KeyManagementException e) {
            logger.error("Init SSL KeyManagement Error", (Throwable)e);
            throw new SdkException("Init SSL KeyManagement Error", e);
        }
    }

    public static X509TrustManager getX509TrustManager() {
        return TRUST_MANAGER;
    }

    static {
        if (Security.getProvider("BGMProvider") == null) {
            Security.addProvider(BGM_PROVIDER);
        }
    }
}

