/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.text.MessageFormat;
import java.util.Locale;
import org.openeuler.SM2KeyExchangeUtil;
import org.openeuler.sun.misc.HexDumpEncoder;
import org.openeuler.sun.security.ssl.Alert;
import org.openeuler.sun.security.ssl.ClientHandshakeContext;
import org.openeuler.sun.security.ssl.ConnectionContext;
import org.openeuler.sun.security.ssl.GMX509Authentication;
import org.openeuler.sun.security.ssl.HandshakeContext;
import org.openeuler.sun.security.ssl.HandshakeOutStream;
import org.openeuler.sun.security.ssl.HandshakeProducer;
import org.openeuler.sun.security.ssl.JsseJce;
import org.openeuler.sun.security.ssl.RSASignature;
import org.openeuler.sun.security.ssl.Record;
import org.openeuler.sun.security.ssl.SM2KeyExchange;
import org.openeuler.sun.security.ssl.SSLConsumer;
import org.openeuler.sun.security.ssl.SSLCredentials;
import org.openeuler.sun.security.ssl.SSLHandshake;
import org.openeuler.sun.security.ssl.SSLLogger;
import org.openeuler.sun.security.ssl.SSLPossession;
import org.openeuler.sun.security.ssl.ServerHandshakeContext;
import org.openeuler.sun.security.ssl.SignatureScheme;
import org.openeuler.sun.security.ssl.SupportedGroupsExtension;
import org.openeuler.sun.security.ssl.Utilities;
import sun.security.util.ECUtil;

final class SM2ServerKeyExchange {
    static final SSLConsumer sm2HandshakeConsumer = new SM2ServerKeyExchangeConsumer();
    static final HandshakeProducer sm2HandshakeProducer = new SM2ServerKeyExchangeProducer();

    SM2ServerKeyExchange() {
    }

    private static final class SM2ServerKeyExchangeConsumer
    implements SSLConsumer {
        private SM2ServerKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            SM2ServerKeyExchangeMessage skem = new SM2ServerKeyExchangeMessage(chc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming SM2 ServerKeyExchange handshake message", skem);
            }
            GMX509Authentication.GMX509Credentials gmx509Credentials = null;
            for (SSLCredentials sslCredentials : chc.handshakeCredentials) {
                if (!(sslCredentials instanceof GMX509Authentication.GMX509Credentials)) continue;
                gmx509Credentials = (GMX509Authentication.GMX509Credentials)sslCredentials;
                break;
            }
            chc.handshakeCredentials.add(new SM2KeyExchange.SM2Credentials((ECPublicKey)gmx509Credentials.popEncPublicKey, skem.namedGroup, skem.publicPoint));
        }
    }

    private static final class SM2ServerKeyExchangeProducer
    implements HandshakeProducer {
        private SM2ServerKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            SM2ServerKeyExchangeMessage skem = new SM2ServerKeyExchangeMessage(shc);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced SM2 ServerKeyExchange handshake message", skem);
            }
            skem.write(shc.handshakeOutput);
            shc.handshakeOutput.flush();
            return null;
        }
    }

    private static final class SM2ServerKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private static final byte CURVE_NAMED_CURVE = 3;
        private final SupportedGroupsExtension.NamedGroup namedGroup;
        private final byte[] publicPoint;
        private final byte[] paramsSignature;
        private final boolean useExplicitSigAlgorithm;
        private final SignatureScheme signatureScheme;

        SM2ServerKeyExchangeMessage(HandshakeContext handshakeContext) throws IOException {
            super(handshakeContext);
            ServerHandshakeContext shc = (ServerHandshakeContext)handshakeContext;
            SM2KeyExchange.SM2Possession sm2Possession = null;
            GMX509Authentication.GMX509Possession gmx509Possession = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (possession instanceof SM2KeyExchange.SM2Possession) {
                    sm2Possession = (SM2KeyExchange.SM2Possession)possession;
                    if (gmx509Possession == null) continue;
                    break;
                }
                if (!(possession instanceof GMX509Authentication.GMX509Possession)) continue;
                gmx509Possession = (GMX509Authentication.GMX509Possession)possession;
                if (sm2Possession == null) continue;
                break;
            }
            if (sm2Possession == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No SM2 credentials negotiated for server key exchange");
            }
            ECPublicKey publicKey = sm2Possession.publicKey;
            ECParameterSpec params = publicKey.getParams();
            this.publicPoint = ECUtil.encodePoint(SM2KeyExchangeUtil.generateR(publicKey, sm2Possession.randomNum), params.getCurve());
            this.namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(params);
            if (this.namedGroup == null || this.namedGroup.oid == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unnamed EC parameter spec: " + params);
            }
            if (gmx509Possession == null) {
                this.paramsSignature = null;
                this.signatureScheme = null;
                this.useExplicitSigAlgorithm = false;
            } else {
                byte[] signature;
                Signature signer;
                this.useExplicitSigAlgorithm = shc.t12WithGMCipherSuite;
                if (this.useExplicitSigAlgorithm) {
                    if (shc.peerRequestedSignatureSchemes == null || !shc.peerRequestedSignatureSchemes.contains((Object)SignatureScheme.ECDSA_SM3)) {
                        throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "No supported signature algorithm for " + gmx509Possession.popSignPrivateKey.getAlgorithm() + "  key");
                    }
                    this.signatureScheme = SignatureScheme.ECDSA_SM3;
                } else {
                    this.signatureScheme = null;
                }
                try {
                    signer = SM2ServerKeyExchangeMessage.getSignature(gmx509Possession.popSignPrivateKey.getAlgorithm(), gmx509Possession.popSignPrivateKey);
                }
                catch (InvalidKeyException | NoSuchAlgorithmException e) {
                    throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + gmx509Possession.popSignPrivateKey.getAlgorithm(), e);
                }
                try {
                    SM2ServerKeyExchangeMessage.updateSignature(signer, shc.clientHelloRandom.randomBytes, shc.serverHelloRandom.randomBytes, this.namedGroup.id, this.publicPoint);
                    signature = signer.sign();
                }
                catch (SignatureException ex) {
                    throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Failed to sign sm2 parameters: " + gmx509Possession.popSignPrivateKey.getAlgorithm(), ex);
                }
                this.paramsSignature = signature;
            }
        }

        SM2ServerKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            Signature signer;
            ClientHandshakeContext chc = (ClientHandshakeContext)handshakeContext;
            Record.getInt8(m);
            int namedGroupId = Record.getInt16(m);
            this.namedGroup = SupportedGroupsExtension.NamedGroup.SM2P256V1;
            this.publicPoint = Record.getBytes8(m);
            if (this.publicPoint.length == 0) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Insufficient ECPoint data: " + (Object)((Object)this.namedGroup));
            }
            GMX509Authentication.GMX509Credentials x509Credentials = null;
            for (SSLCredentials cd : chc.handshakeCredentials) {
                if (!(cd instanceof GMX509Authentication.GMX509Credentials)) continue;
                x509Credentials = (GMX509Authentication.GMX509Credentials)cd;
                break;
            }
            if (x509Credentials == null) {
                if (m.hasRemaining()) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid DH ServerKeyExchange: unknown extra data");
                }
                this.signatureScheme = null;
                this.paramsSignature = null;
                this.useExplicitSigAlgorithm = false;
                return;
            }
            this.useExplicitSigAlgorithm = chc.t12WithGMCipherSuite;
            if (this.useExplicitSigAlgorithm) {
                int ssid = Record.getInt16(m);
                this.signatureScheme = SignatureScheme.valueOf(ssid);
                if (this.signatureScheme != SignatureScheme.ECDSA_SM3) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature algorithm (" + ssid + ") used in SM2 ServerKeyExchange handshake message");
                }
                if (!chc.localSupportedSignAlgs.contains((Object)this.signatureScheme)) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsupported signature algorithm (" + this.signatureScheme.name + ") used in SM2 ServerKeyExchange handshake message");
                }
            } else {
                this.signatureScheme = null;
            }
            this.paramsSignature = Record.getBytes16(m);
            try {
                signer = SM2ServerKeyExchangeMessage.getSignature(x509Credentials.popSignPublicKey.getAlgorithm(), x509Credentials.popSignPublicKey);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + x509Credentials.popSignPublicKey.getAlgorithm(), e);
            }
            try {
                SM2ServerKeyExchangeMessage.updateSignature(signer, chc.clientHelloRandom.randomBytes, chc.serverHelloRandom.randomBytes, namedGroupId, this.publicPoint);
                if (!signer.verify(this.paramsSignature)) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid SM2 ServerKeyExchange signature");
                }
            }
            catch (SignatureException ex) {
                throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify SM2 ServerKeyExchange signature", ex);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.SERVER_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            int sigLen = 0;
            if (this.paramsSignature != null) {
                sigLen = 2 + this.paramsSignature.length;
                if (this.useExplicitSigAlgorithm) {
                    sigLen += SignatureScheme.sizeInRecord();
                }
            }
            return 4 + this.publicPoint.length + sigLen;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            hos.putInt8(3);
            hos.putInt16(this.namedGroup.id);
            hos.putBytes8(this.publicPoint);
            if (this.paramsSignature != null) {
                if (this.useExplicitSigAlgorithm) {
                    hos.putInt16(this.signatureScheme.id);
                }
                hos.putBytes16(this.paramsSignature);
            }
        }

        public String toString() {
            if (this.useExplicitSigAlgorithm) {
                MessageFormat messageFormat = new MessageFormat("\"SM2 ServerKeyExchange\": '{'\n  \"parameters\": '{'\n    \"named group\": \"{0}\"\n    \"sm2 public\": '{'\n{1}\n    '}',\n  '}',\n  \"digital signature\":  '{'\n    \"signature algorithm\": \"{2}\"\n    \"signature\": '{'\n{3}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexEncoder = new HexDumpEncoder();
                Object[] messageFields = new Object[]{this.namedGroup.name, Utilities.indent(hexEncoder.encodeBuffer(this.publicPoint), "      "), this.signatureScheme.name, Utilities.indent(hexEncoder.encodeBuffer(this.paramsSignature), "      ")};
                return messageFormat.format(messageFields);
            }
            if (this.paramsSignature != null) {
                MessageFormat messageFormat = new MessageFormat("\"SM2 ServerKeyExchange\": '{'\n  \"parameters\":  '{'\n    \"named group\": \"{0}\"\n    \"sm2 public\": '{'\n{1}\n    '}',\n  '}',\n  \"signature\": '{'\n{2}\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexEncoder = new HexDumpEncoder();
                Object[] messageFields = new Object[]{this.namedGroup.name, Utilities.indent(hexEncoder.encodeBuffer(this.publicPoint), "      "), Utilities.indent(hexEncoder.encodeBuffer(this.paramsSignature), "    ")};
                return messageFormat.format(messageFields);
            }
            MessageFormat messageFormat = new MessageFormat("\"SM2 ServerKeyExchange\": '{'\n  \"parameters\":  '{'\n    \"named group\": \"{0}\"\n    \"sm2 public\": '{'\n{1}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{this.namedGroup.name, Utilities.indent(hexEncoder.encodeBuffer(this.publicPoint), "      ")};
            return messageFormat.format(messageFields);
        }

        private static Signature getSignature(String keyAlgorithm, Key key) throws NoSuchAlgorithmException, InvalidKeyException {
            Signature signer = null;
            switch (keyAlgorithm) {
                case "EC": {
                    signer = JsseJce.getSignature("SM3WithSM2");
                    break;
                }
                case "RSA": {
                    signer = RSASignature.getInstance();
                    break;
                }
                default: {
                    throw new NoSuchAlgorithmException("neither an RSA or a EC key : " + keyAlgorithm);
                }
            }
            if (signer != null) {
                if (key instanceof PublicKey) {
                    signer.initVerify((PublicKey)key);
                } else {
                    signer.initSign((PrivateKey)key);
                }
            }
            return signer;
        }

        private static void updateSignature(Signature sig, byte[] clntNonce, byte[] svrNonce, int namedGroupId, byte[] publicPoint) throws SignatureException {
            sig.update(clntNonce);
            sig.update(svrNonce);
            sig.update((byte)3);
            sig.update((byte)(namedGroupId >> 8 & 0xFF));
            sig.update((byte)(namedGroupId & 0xFF));
            sig.update((byte)publicPoint.length);
            sig.update(publicPoint);
        }
    }
}

