/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.auth.AbstractHasher;
import com.huaweicloud.sdk.core.auth.IAKSKSigner;
import com.huaweicloud.sdk.core.auth.ISigningKey;
import com.huaweicloud.sdk.core.auth.SHA256Hasher;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.utils.BinaryUtils;
import com.huaweicloud.sdk.core.utils.SignUtils;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SimpleTimeZone;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class AKSKSigner
implements IAKSKSigner {
    private static final AKSKSigner SINGLETON = new AKSKSigner();
    protected AbstractHasher hasher = new SHA256Hasher();
    protected String algorithm = "SDK-HMAC-SHA256";
    protected String contentHeader = "X-Sdk-Content-Sha256";
    protected String emptyHash = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";

    protected AKSKSigner() {
    }

    public static AKSKSigner getInstance() {
        return SINGLETON;
    }

    protected <T extends AbstractCredentials<T>> void checkRequired(T credential) {
        if (Objects.isNull(credential)) {
            throw new SdkException("credentials is required");
        }
        if (StringUtils.isEmpty(credential.getAk())) {
            throw new SdkException("ak is required in credentials");
        }
        if (StringUtils.isEmpty(credential.getSk())) {
            throw new SdkException("sk in credentials is required");
        }
    }

    @Override
    public <T extends AbstractCredentials<T>> Map<String, String> sign(HttpRequest request, T credentials) {
        this.checkRequired(credentials);
        HashMap<String, String> authenticationHeaders = new HashMap<String, String>();
        URL url = request.getUrl();
        String canonicalHost = request.haveHeader("Host") != false ? request.getHeader("Host") : url.getAuthority();
        authenticationHeaders.put("Host", canonicalHost);
        String dateTimeStamp = this.extractTimeStamp(request, authenticationHeaders);
        Map<String, String> allHeaders = this.combineAllHeaders(request, authenticationHeaders);
        String canonicalUri = this.buildCanonicalUri(url);
        String query = url.getQuery();
        Map<String, List<String>> parameters = request.getQueryParams();
        String canonicalQueryString = this.buildCanonicalQueryString(query, parameters);
        String signedHeaderNames = String.join((CharSequence)";", allHeaders.keySet());
        String canonicalHeaders = this.buildCanonicalHeaders(allHeaders);
        String payloadHash = this.buildPayloadHash(request);
        String canonicalRequest = this.buildCanonicalRequest(request.getMethod().name(), canonicalUri, canonicalQueryString, canonicalHeaders, signedHeaderNames, payloadHash);
        String canonicalRequestHash = this.hasher.hashHexString(canonicalRequest.getBytes(StandardCharsets.UTF_8));
        String stringToSign = this.buildStringToSign(this.algorithm, dateTimeStamp, canonicalRequestHash);
        ISigningKey signingKey = this.getSigningKey(credentials);
        String signature = this.buildSignature(stringToSign, signingKey);
        String authorization = String.format(Locale.ROOT, "%s Access=%s, SignedHeaders=%s, Signature=%s", this.algorithm, credentials.getAk(), signedHeaderNames, signature);
        authenticationHeaders.put("Authorization", authorization);
        return authenticationHeaders;
    }

    public <T extends AbstractCredentials<T>> ISigningKey getSigningKey(T credentials) {
        return new HmacSigningKey(this.hasher, credentials.getSk().getBytes(StandardCharsets.UTF_8));
    }

    protected String extractTimeStamp(HttpRequest request, Map<String, String> authenticationHeaders) {
        if (request.haveHeader("X-Sdk-Date").booleanValue()) {
            return request.getHeader("X-Sdk-Date");
        }
        SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        isoDateFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        String dateTimeStamp = isoDateFormat.format(new Date());
        authenticationHeaders.put("X-Sdk-Date", dateTimeStamp);
        return dateTimeStamp;
    }

    protected Map<String, String> combineAllHeaders(HttpRequest request, Map<String, String> authenticationHeaders) {
        TreeMap<String, String> allHeaders = new TreeMap<String, String>();
        allHeaders.putAll(request.getHeaders().entrySet().stream().filter(entry -> !((String)entry.getKey()).equalsIgnoreCase("Content-Type") && !((String)entry.getKey()).contains("_")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(Locale.ROOT), entry -> (String)((List)entry.getValue()).get(0))));
        allHeaders.putAll(authenticationHeaders.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(Locale.ROOT), Map.Entry::getValue)));
        return allHeaders;
    }

    protected String buildCanonicalUri(URL url) {
        String[] split;
        String pathOld = url.getPath();
        if (pathOld.equals("/")) {
            return pathOld;
        }
        StringBuilder canonicalUri = new StringBuilder();
        for (String urlSplit : split = pathOld.split("/")) {
            canonicalUri.append(SignUtils.urlEncode(urlSplit, false)).append("/");
        }
        return canonicalUri.toString();
    }

    protected String buildCanonicalQueryString(String query, Map<String, List<String>> parameters) {
        SortedMap<String, List<String>> sorted2 = SignUtils.convertQuery2SortedMap(query);
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        for (Map.Entry<String, List<String>> pair : parameters.entrySet()) {
            String key = pair.getKey();
            List<String> values2 = pair.getValue();
            ArrayList<String> escapedValues = new ArrayList<String>();
            for (String value : values2) {
                escapedValues.add(SignUtils.urlEncode(value, false));
            }
            sorted2.put(SignUtils.urlEncode(key, false), escapedValues);
        }
        return SignUtils.convertSortedMap2QueryString(sorted2);
    }

    protected String buildCanonicalHeaders(Map<String, String> headers) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            sb.append(entry.getKey().toLowerCase(Locale.ROOT)).append(":").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    protected String buildPayloadHash(HttpRequest request) {
        if (request.haveHeader(this.contentHeader).booleanValue()) {
            return request.getHeader(this.contentHeader);
        }
        if (Objects.nonNull(request.getBodyAsString()) && !request.getBodyAsString().isEmpty()) {
            return this.hasher.hashHexString(request.getBodyAsString().getBytes(StandardCharsets.UTF_8));
        }
        if (Objects.nonNull(request.getBody())) {
            try {
                int len = request.getBody().available();
                byte[] body = new byte[len];
                for (int i = 0; i < len; ++i) {
                    int byteRead = request.getBody().read();
                    body[i] = (byte)byteRead;
                }
                request.getBody().reset();
                return this.hasher.hashHexString(body);
            }
            catch (IOException e) {
                throw new SdkException(e);
            }
        }
        return this.emptyHash;
    }

    protected String buildCanonicalRequest(String ... segments) {
        return String.join((CharSequence)"\n", segments);
    }

    protected String buildStringToSign(String ... segments) {
        return String.join((CharSequence)"\n", segments);
    }

    protected String buildSignature(String stringToSign, ISigningKey signingKey) {
        byte[] signed = signingKey.sign(stringToSign.getBytes(StandardCharsets.UTF_8));
        return BinaryUtils.toHex(signed);
    }

    protected static class HmacSigningKey
    implements ISigningKey {
        private final AbstractHasher hasher;
        private final byte[] key;

        HmacSigningKey(AbstractHasher hasher, byte[] key) {
            this.hasher = hasher;
            this.key = key;
        }

        @Override
        public byte[] sign(byte[] data) {
            return this.hasher.hmac(data, this.key);
        }

        @Override
        public boolean verify(byte[] signature, byte[] data) {
            byte[] hmac = this.hasher.hmac(data, this.key);
            return Arrays.equals(signature, hmac);
        }
    }
}

