/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870.client;

import java.util.Objects;
import org.apache.camel.component.iec60870.BaseOptions;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions;

@UriParams
public class ClientOptions
extends BaseOptions<ClientOptions> {
    @UriParam(javaType="org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions")
    private DataModuleOptions.Builder dataModuleOptions;
    @UriParam(label="data", defaultValue="true")
    private boolean ignoreBackgroundScan = true;
    @UriParam(label="data")
    private byte causeSourceAddress;
    @UriParam(label="data", defaultValue="10000")
    private int connectionTimeout = 10000;

    public ClientOptions() {
        this.dataModuleOptions = new DataModuleOptions.Builder();
    }

    public ClientOptions(ClientOptions other) {
        this(other.getProtocolOptions(), other.getDataModuleOptions());
    }

    public ClientOptions(ProtocolOptions protocolOptions, DataModuleOptions dataOptions) {
        super(protocolOptions);
        Objects.requireNonNull(dataOptions);
        this.dataModuleOptions = new DataModuleOptions.Builder(dataOptions);
    }

    public void setDataModuleOptions(DataModuleOptions dataModuleOptions) {
        Objects.requireNonNull(dataModuleOptions);
        this.dataModuleOptions = new DataModuleOptions.Builder(dataModuleOptions);
    }

    public DataModuleOptions getDataModuleOptions() {
        return this.dataModuleOptions.build();
    }

    @Override
    public ClientOptions copy() {
        return new ClientOptions(this);
    }

    public byte getCauseSourceAddress() {
        return this.causeSourceAddress;
    }

    public void setCauseSourceAddress(byte causeSourceAddress) {
        this.causeSourceAddress = causeSourceAddress;
        this.dataModuleOptions.setCauseSourceAddress(causeSourceAddress);
    }

    public void setIgnoreBackgroundScan(boolean ignoreBackgroundScan) {
        this.dataModuleOptions.setIgnoreBackgroundScan(ignoreBackgroundScan);
    }

    public boolean isIgnoreBackgroundScan() {
        return this.dataModuleOptions.isIgnoreBackgroundScan();
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }
}

