/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.client.data;

import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.DoublePointInformationSequence;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.DoublePointInformationSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.DoublePointInformationTimeSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueScaledSequence;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueScaledSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueScaledTimeSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueShortFloatingPointSequence;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueShortFloatingPointSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueShortFloatingPointTimeSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SinglePointInformationSequence;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SinglePointInformationSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SinglePointInformationTimeSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.DoublePoint;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataHandler;

public abstract class AbstractDataProcessor
implements DataHandler {
    protected abstract void fireEntry(ASDUAddress var1, InformationObjectAddress var2, Value<?> var3);

    protected boolean checkIgnore(AbstractMessage msg) {
        return false;
    }

    @Override
    public void process(SinglePointInformationTimeSingle msg) {
        if (this.checkIgnore(msg)) {
            return;
        }
        for (InformationEntry<Boolean> entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(SinglePointInformationSingle msg) {
        if (this.checkIgnore(msg)) {
            return;
        }
        for (InformationEntry<Boolean> entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(SinglePointInformationSequence msg) {
        if (this.checkIgnore(msg)) {
            return;
        }
        int i = msg.getStartAddress().getAddress();
        for (Value<Boolean> value : msg.getValues()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), InformationObjectAddress.valueOf(i), value);
            ++i;
        }
    }

    @Override
    public void process(DoublePointInformationTimeSingle msg) {
        if (this.checkIgnore(msg)) {
            return;
        }
        for (InformationEntry<DoublePoint> entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(DoublePointInformationSingle msg) {
        if (this.checkIgnore(msg)) {
            return;
        }
        for (InformationEntry<DoublePoint> entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(DoublePointInformationSequence msg) {
        if (this.checkIgnore(msg)) {
            return;
        }
        int i = msg.getStartAddress().getAddress();
        for (Value<DoublePoint> value : msg.getValues()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), InformationObjectAddress.valueOf(i), value);
            ++i;
        }
    }

    @Override
    public void process(MeasuredValueShortFloatingPointTimeSingle msg) {
        if (this.checkIgnore(msg)) {
            return;
        }
        for (InformationEntry<Float> entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(MeasuredValueShortFloatingPointSingle msg) {
        if (this.checkIgnore(msg)) {
            return;
        }
        for (InformationEntry<Float> entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(MeasuredValueShortFloatingPointSequence msg) {
        if (this.checkIgnore(msg)) {
            return;
        }
        int i = msg.getStartAddress().getAddress();
        for (Value<Float> value : msg.getValues()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), InformationObjectAddress.valueOf(i), value);
            ++i;
        }
    }

    @Override
    public void process(MeasuredValueScaledTimeSingle msg) {
        if (this.checkIgnore(msg)) {
            return;
        }
        for (InformationEntry<Short> entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(MeasuredValueScaledSingle msg) {
        if (this.checkIgnore(msg)) {
            return;
        }
        for (InformationEntry<Short> entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(MeasuredValueScaledSequence msg) {
        if (this.checkIgnore(msg)) {
            return;
        }
        int i = msg.getStartAddress().getAddress();
        for (Value<Short> value : msg.getValues()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), InformationObjectAddress.valueOf(i), value);
            ++i;
        }
    }
}

