/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data.event;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CauseOfTransmission;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.MessageBuilder;

public class EventBuffer<T> {
    private final LinkedList<Entry<T>> entries = new LinkedList();
    private final Map<Header, Integer> causeCounter = new HashMap<Header, Integer>();
    private final int numberOfDuplicates;

    public EventBuffer(int numberOfDuplicates) {
        this.numberOfDuplicates = numberOfDuplicates;
    }

    public void append(CauseOfTransmission causeOfTransmission, ASDUAddress asduAddress, InformationObjectAddress address, Value<T> value) {
        Header header = new Header(causeOfTransmission, asduAddress);
        this.removeDuplicates(address, header);
        this.entries.add(new Entry<T>(header, address, value));
        this.incrementCauseCounter(header, 1);
    }

    public void append(CauseOfTransmission causeOfTransmission, ASDUAddress asduAddress, InformationObjectAddress startAddress, List<Value<T>> values) {
        Header header = new Header(causeOfTransmission, asduAddress);
        int addr = startAddress.getAddress();
        for (Value<T> value : values) {
            InformationObjectAddress address = new InformationObjectAddress(addr);
            this.removeDuplicates(address, header);
            this.entries.add(new Entry<T>(header, address, value));
            this.incrementCauseCounter(header, 1);
            ++addr;
        }
    }

    public void append(CauseOfTransmission causeOfTransmission, ASDUAddress asduAddress, List<InformationEntry<T>> values) {
        Header header = new Header(causeOfTransmission, asduAddress);
        for (InformationEntry<T> value : values) {
            InformationObjectAddress address = value.getAddress();
            this.removeDuplicates(address, header);
            this.entries.add(new Entry<T>(header, address, value.getValue()));
            this.incrementCauseCounter(header, 1);
        }
    }

    public int getCauseCounter(CauseOfTransmission causeOfTransmission, ASDUAddress asduAddress) {
        Integer result = this.causeCounter.get(new Header(causeOfTransmission, asduAddress));
        if (result == null) {
            return 0;
        }
        return result;
    }

    private void removeDuplicates(InformationObjectAddress address, Header header) {
        int count = 0;
        int removed = 0;
        Iterator i = this.entries.iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            if (!entry.getAddress().equals(address) || !entry.getHeader().equals(header) || ++count < this.numberOfDuplicates) continue;
            ++removed;
            i.remove();
        }
        this.incrementCauseCounter(header, -removed);
    }

    private void incrementCauseCounter(Header header, int amount) {
        Integer counter = this.causeCounter.get(header);
        if (counter == null) {
            this.causeCounter.put(header, Math.max(0, amount));
        } else {
            this.causeCounter.put(header, counter + amount);
        }
    }

    public <M> M poll(MessageBuilder<T, M> builder) {
        Iterator i = this.entries.iterator();
        Header header = null;
        HashSet<InformationObjectAddress> visited = new HashSet<InformationObjectAddress>();
        HashSet<InformationObjectAddress> added = new HashSet<InformationObjectAddress>();
        int removed = 0;
        boolean accepts = true;
        while (i.hasNext() && accepts) {
            Entry entry = (Entry)i.next();
            boolean seenWithOtherCause = visited.contains(entry.getAddress());
            boolean contained = added.contains(entry.getAddress());
            if (header == null) {
                header = entry.getHeader();
                builder.start(header.getCauseOfTransmission(), header.getAsduAddress());
                i.remove();
                accepts = builder.addEntry(entry.getAddress(), entry.getValue());
                added.add(entry.getAddress());
                ++removed;
                continue;
            }
            if (!header.equals(entry.getHeader())) {
                if (contained) break;
                visited.add(entry.getAddress());
                continue;
            }
            if (seenWithOtherCause) continue;
            i.remove();
            accepts = builder.addEntry(entry.getAddress(), entry.getValue());
            added.add(entry.getAddress());
            ++removed;
        }
        if (header == null) {
            return null;
        }
        this.incrementCauseCounter(header, -removed);
        return builder.build();
    }

    private static class Entry<T> {
        private final InformationObjectAddress address;
        private final Header header;
        private final Value<T> value;

        public Entry(Header header, InformationObjectAddress address, Value<T> value) {
            this.header = header;
            this.address = address;
            this.value = value;
        }

        public InformationObjectAddress getAddress() {
            return this.address;
        }

        public Header getHeader() {
            return this.header;
        }

        public Value<T> getValue() {
            return this.value;
        }
    }

    private static class Header {
        private final CauseOfTransmission causeOfTransmission;
        private final ASDUAddress asduAddress;

        public Header(CauseOfTransmission causeOfTransmission, ASDUAddress asduAddress) {
            this.causeOfTransmission = causeOfTransmission;
            this.asduAddress = asduAddress;
        }

        public ASDUAddress getAsduAddress() {
            return this.asduAddress;
        }

        public CauseOfTransmission getCauseOfTransmission() {
            return this.causeOfTransmission;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.asduAddress == null ? 0 : this.asduAddress.hashCode());
            result = 31 * result + (this.causeOfTransmission == null ? 0 : this.causeOfTransmission.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Header other = (Header)obj;
            if (this.asduAddress == null ? other.asduAddress != null : !this.asduAddress.equals(other.asduAddress)) {
                return false;
            }
            return !(this.causeOfTransmission == null ? other.causeOfTransmission != null : !this.causeOfTransmission.equals(other.causeOfTransmission));
        }
    }
}

