/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.concurrent.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.eclipse.scada.utils.concurrent.FutureListener;

public class FutureTaskNotifier<T> {
    private final Object lock = new Object();
    private final Set<FutureListener<T>> listeners = new HashSet<FutureListener<T>>(1);
    private final Set<Runnable> runnables = new HashSet<Runnable>();
    private boolean done = false;
    private final Future<T> future;

    public FutureTaskNotifier(Future<T> future) {
        this.future = future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        HashSet<Runnable> runnables;
        HashSet<FutureListener<T>> listeners;
        Object object = this.lock;
        synchronized (object) {
            if (this.done) {
                return;
            }
            this.done = true;
            listeners = new HashSet<FutureListener<T>>(this.listeners);
            runnables = new HashSet<Runnable>(this.runnables);
        }
        for (FutureListener futureListener : listeners) {
            try {
                futureListener.complete(this.future);
            }
            catch (Throwable throwable) {}
        }
        for (Runnable runnable : runnables) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {}
        }
        this.listeners.clear();
        this.runnables.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Runnable listener) {
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.done) {
                notifyNow = true;
            } else {
                this.runnables.add(listener);
            }
        }
        if (notifyNow) {
            listener.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Runnable listener) {
        Object object = this.lock;
        synchronized (object) {
            this.runnables.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FutureListener<T> listener) {
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.done) {
                notifyNow = true;
            } else {
                this.listeners.add(listener);
            }
        }
        if (notifyNow) {
            listener.complete(this.future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FutureListener<T> listener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }
}

