/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.interner;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import org.eclipse.scada.utils.interner.JavaStringInterner;

public final class InternerHelper {
    private InternerHelper() {
    }

    public static Interner<String> makeInterner(String specificPropertyName, String defaultType) {
        String type = System.getProperty(specificPropertyName, System.getProperty("org.eclipse.scada.defaultStringInterner", defaultType));
        if ("weak".equals(type)) {
            return new NullSafeInterner(Interners.newWeakInterner());
        }
        if ("strong".equals(type)) {
            return new NullSafeInterner(Interners.newStrongInterner());
        }
        if ("java".equals(type)) {
            return new JavaStringInterner();
        }
        return InternerHelper.makeNoOpInterner();
    }

    public static Interner<String> makeNoOpInterner() {
        return new Interner<String>(){

            @Override
            public String intern(String string) {
                return string;
            }
        };
    }

    private static class NullSafeInterner
    implements Interner<String> {
        private final Interner<String> interner;

        private NullSafeInterner(Interner<String> interner) {
            this.interner = interner;
        }

        @Override
        public String intern(String string) {
            if (string == null) {
                return null;
            }
            return this.interner.intern(string);
        }
    }
}

