/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractInformationObjectMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MirrorableMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;

@ASDU(id=45, name="C_SC_NA_1", informationStructure=InformationStructure.SINGLE)
public class SingleCommand
extends AbstractInformationObjectMessage
implements MirrorableMessage<SingleCommand> {
    private final boolean state;
    private final byte type;
    private final boolean execute;

    public SingleCommand(ASDUHeader header, InformationObjectAddress informationObjectAddress, boolean state, byte type, boolean execute) {
        super(header, informationObjectAddress);
        this.state = state;
        this.type = type;
        this.execute = execute;
    }

    public SingleCommand(ASDUHeader header, InformationObjectAddress informationObjectAddress, boolean state) {
        this(header, informationObjectAddress, state, 0, true);
    }

    public byte getType() {
        return this.type;
    }

    public boolean isState() {
        return this.state;
    }

    public boolean getState() {
        return this.state;
    }

    public boolean isExecute() {
        return this.execute;
    }

    @Override
    public SingleCommand mirror(Cause cause, boolean positive) {
        return new SingleCommand(this.header.clone(cause, positive), this.informationObjectAddress, this.state, this.type, this.execute);
    }

    @Override
    public void encode(ProtocolOptions options, ByteBuf out) {
        EncodeHelper.encodeHeader(this, options, null, this.header, out);
        byte b = 0;
        b = (byte)(b | (this.state ? 1 : 0));
        b = (byte)(b | this.type << 2 & 0xFC);
        b = (byte)(b | (this.execute ? 0 : 256));
        this.informationObjectAddress.encode(options, out);
        out.writeByte(b);
    }

    public static SingleCommand parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        InformationObjectAddress address = InformationObjectAddress.parse(options, data);
        byte b = data.readByte();
        boolean state = (b & 1) > 0;
        byte type = (byte)((b & 0xFC) >> 2);
        boolean execute = (b & 0x100) <= 0;
        return new SingleCommand(header, address, state, type, execute);
    }
}

