/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.io;

import com.google.common.util.concurrent.FutureCallback;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MirrorableMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.StandardCause;
import org.eclipse.neoscada.protocol.iec60870.io.MirrorCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractModuleHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMirrorCommand.class);

    protected abstract class CloseOnFailureCallback
    implements FutureCallback<Void> {
        private final ChannelHandlerContext ctx;

        public CloseOnFailureCallback(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void onFailure(Throwable t2) {
            logger.warn("Failed", t2);
            this.ctx.close();
        }
    }

    protected static final class DefaultMirrorCommand<T extends MirrorableMessage<T>>
    extends MirrorCommandImpl<T> {
        final /* synthetic */ AbstractModuleHandler this$0;

        public DefaultMirrorCommand(ChannelHandlerContext ctx, T original) {
            this.this$0 = var1_1;
            super(ctx, original);
        }

        @Override
        public T mirrorCommand(T original, Cause newCause, boolean positive) {
            return (T)((MirrorableMessage)original.mirror(newCause, positive));
        }
    }

    protected static abstract class MirrorCommandImpl<T>
    implements MirrorCommand {
        private final ChannelHandlerContext ctx;
        private final T original;

        public MirrorCommandImpl(ChannelHandlerContext ctx, T original) {
            this.ctx = ctx;
            this.original = original;
        }

        protected abstract T mirrorCommand(T var1, Cause var2, boolean var3);

        @Override
        public void sendActivationTermination() {
            this.ctx.writeAndFlush(this.mirrorCommand(this.original, StandardCause.ACTIVATION_TERMINATION, true));
        }

        @Override
        public void sendActivationConfirm(boolean positive) {
            this.ctx.writeAndFlush(this.mirrorCommand(this.original, StandardCause.ACTIVATION_CONFIRM, positive));
        }
    }
}

