/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.collection;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.scada.utils.collection.BoundedQueue;

public class BoundedPriorityQueueSet<E>
implements SortedSet<E>,
BoundedQueue<E> {
    private final ConcurrentSkipListSet<E> internalSet;
    private final int capacity;

    public BoundedPriorityQueueSet(int capacity) {
        this(capacity, (Comparator<E>)null);
    }

    public BoundedPriorityQueueSet(int capacity, Comparator<E> comparator) {
        if (capacity < 1) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.internalSet = new ConcurrentSkipListSet<E>(comparator);
    }

    public BoundedPriorityQueueSet(int capacity, Collection<E> c) {
        this(capacity, (Comparator<E>)null);
    }

    public BoundedPriorityQueueSet(int capacity, Comparator<E> comparator, Collection<E> c) {
        this(capacity, comparator);
    }

    private void shrinkToSize() {
        int toRemove = this.internalSet.size() - this.capacity;
        if (toRemove <= 0) {
            return;
        }
        int i = 0;
        while (i < toRemove) {
            this.internalSet.pollLast();
            ++i;
        }
    }

    @Override
    public boolean add(E e) {
        boolean result = this.internalSet.add(e);
        if (!result) {
            return false;
        }
        this.shrinkToSize();
        return this.internalSet.contains(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = this.internalSet.addAll(c);
        if (!result) {
            return false;
        }
        this.shrinkToSize();
        for (E e : c) {
            if (!this.internalSet.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.internalSet.clear();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.internalSet.comparator();
    }

    @Override
    public boolean contains(Object o) {
        return this.internalSet.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.internalSet.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.internalSet.equals(o);
    }

    @Override
    public E first() {
        return this.internalSet.first();
    }

    @Override
    public int hashCode() {
        return this.internalSet.hashCode();
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.internalSet.headSet((Object)toElement);
    }

    @Override
    public boolean isEmpty() {
        return this.internalSet.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.internalSet.iterator();
    }

    @Override
    public E last() {
        return this.internalSet.last();
    }

    @Override
    public boolean remove(Object o) {
        return this.internalSet.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.internalSet.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.internalSet.retainAll(c);
    }

    @Override
    public int size() {
        return this.internalSet.size();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.internalSet.subSet((Object)fromElement, (Object)toElement);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.internalSet.tailSet((Object)fromElement);
    }

    @Override
    public Object[] toArray() {
        return this.internalSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.internalSet.toArray(a);
    }

    @Override
    public E element() {
        return this.internalSet.first();
    }

    @Override
    public E peek() {
        try {
            return this.internalSet.first();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public E poll() {
        return this.internalSet.pollFirst();
    }

    @Override
    public E remove() {
        E result = this.internalSet.first();
        this.internalSet.remove(result);
        return result;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }
}

