/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractDoublePointBaseSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.DoublePoint;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

@ASDU(id=31, name="M_DP_TB_1", informationStructure=InformationStructure.SINGLE)
public class DoublePointInformationTimeSingle
extends AbstractDoublePointBaseSingle {
    private DoublePointInformationTimeSingle(ASDUHeader header, List<InformationEntry<DoublePoint>> entries) {
        super(header, entries, true);
    }

    public static DoublePointInformationTimeSingle parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        return new DoublePointInformationTimeSingle(header, DoublePointInformationTimeSingle.parseEntries(options, length, data, true));
    }

    public static DoublePointInformationTimeSingle create(ASDUHeader header, InformationObjectAddress address, Value<DoublePoint> value) {
        return DoublePointInformationTimeSingle.createInternal(header, Collections.singletonList(new InformationEntry<DoublePoint>(address, value)));
    }

    public static DoublePointInformationTimeSingle create(ASDUHeader header, List<InformationEntry<DoublePoint>> values) {
        if (values.size() > 127) {
            throw new IllegalArgumentException(String.format("A maximum of %s values can be transmitted", 127));
        }
        return DoublePointInformationTimeSingle.createInternal(header, new ArrayList<InformationEntry<DoublePoint>>(values));
    }

    private static DoublePointInformationTimeSingle createInternal(ASDUHeader header, List<InformationEntry<DoublePoint>> values) {
        return new DoublePointInformationTimeSingle(header, values);
    }
}

