/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data.model;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.io.MirrorCommand;
import org.eclipse.neoscada.protocol.iec60870.server.data.AbstractBaseDataModel;
import org.eclipse.neoscada.protocol.iec60870.server.data.BackgroundIterator;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataListener;
import org.eclipse.neoscada.protocol.iec60870.server.data.Stopping;
import org.eclipse.neoscada.protocol.iec60870.server.data.model.BackgroundModel;
import org.eclipse.neoscada.protocol.iec60870.server.data.model.BackgroundModelImpl;
import org.eclipse.neoscada.protocol.iec60870.server.data.model.BufferingChangeModel;
import org.eclipse.neoscada.protocol.iec60870.server.data.model.ChangeModel;
import org.eclipse.neoscada.protocol.iec60870.server.data.model.InstantChangeModel;
import org.eclipse.neoscada.protocol.iec60870.server.data.model.WriteModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChangeDataModel
extends AbstractBaseDataModel {
    private static final Logger logger = LoggerFactory.getLogger(ChangeDataModel.class);
    private final SortedMap<Integer, SortedMap<Integer, Value<?>>> cache = new TreeMap();
    private ChangeModel changeModel;
    private WriteModel writeModel;
    private BackgroundModel backgroundModel;

    protected abstract ChangeModel createChangeModel();

    protected abstract WriteModel createWriteModel();

    protected abstract BackgroundModel createBackgroundModel();

    public ChangeDataModel(String threadName) {
        super(threadName);
    }

    @Override
    public synchronized void start() {
        if (this.changeModel != null) {
            return;
        }
        super.start();
        this.changeModel = this.createChangeModel();
        this.writeModel = this.createWriteModel();
        this.backgroundModel = this.createBackgroundModel();
    }

    @Override
    public Stopping stop() {
        return this.internalDispose().andThen(super.stop());
    }

    private synchronized Stopping internalDispose() {
        final Optional<Runnable> cmDispose = Optional.ofNullable(this.changeModel).map(ChangeModel::dispose);
        final Optional<Runnable> wmDispose = Optional.ofNullable(this.writeModel).map(WriteModel::dispose);
        final Optional<Runnable> bmDispose = Optional.ofNullable(this.backgroundModel).map(BackgroundModel::dispose);
        this.changeModel = null;
        this.writeModel = null;
        this.backgroundModel = null;
        return new Stopping(){

            @Override
            public void await() throws Exception {
                cmDispose.ifPresent(Runnable::run);
                wmDispose.ifPresent(Runnable::run);
                bmDispose.ifPresent(Runnable::run);
            }
        };
    }

    protected BackgroundModel makeDefaultBackgroundModel() {
        return new BackgroundModelImpl(this.cache, this);
    }

    protected ChangeModel makeInstantChangeModel() {
        return new InstantChangeModel(new InstantChangeModel.Context(){

            @Override
            public void notifyChangeBoolean(ASDUAddress asduAddress, InformationObjectAddress startAddress, List<Value<Boolean>> values) {
                ChangeDataModel.this.notifyChangeBoolean(asduAddress, startAddress, values);
            }

            @Override
            public void notifyChangeFloat(ASDUAddress asduAddress, InformationObjectAddress startAddress, List<Value<Float>> values) {
                ChangeDataModel.this.notifyChangeFloat(asduAddress, startAddress, values);
            }

            @Override
            public void notifyChangeShort(ASDUAddress asduAddress, InformationObjectAddress startAddress, List<Value<Short>> values) {
                ChangeDataModel.this.notifyChangeShort(asduAddress, startAddress, values);
            }
        });
    }

    protected ChangeModel makeBufferingChangeModel(long flushDelay) {
        return new BufferingChangeModel(new BufferingChangeModel.Context(){

            @Override
            public void notifyBoolean(ASDUAddress asduAddress, List<InformationEntry<Boolean>> values) {
                ChangeDataModel.this.notifyChangeBoolean(asduAddress, values);
            }

            @Override
            public void notifyFloat(ASDUAddress asduAddress, List<InformationEntry<Float>> values) {
                ChangeDataModel.this.notifyChangeFloat(asduAddress, values);
            }

            @Override
            public void notifyShort(ASDUAddress asduAddress, List<InformationEntry<Short>> values) {
                ChangeDataModel.this.notifyChangeShort(asduAddress, values);
            }
        }, this.executor, flushDelay);
    }

    @Override
    public BackgroundIterator createBackgroundIterator() {
        return this.backgroundModel.createBackgroundIterator().orElse(null);
    }

    protected synchronized void notifyDataChange(ASDUAddress asduAddress, InformationObjectAddress informationObjectAddress, Value<?> value, boolean notify) {
        logger.trace("Notify data change - ASDU: {}, IOA: {}, value: {}", new Object[]{asduAddress, informationObjectAddress, value});
        TreeMap unit = (TreeMap)this.cache.get(asduAddress.getAddress());
        if (unit == null) {
            unit = new TreeMap();
            this.cache.put(asduAddress.getAddress(), unit);
        }
        unit.put(informationObjectAddress.getAddress(), value);
        this.changeModel.notifyChange(asduAddress, informationObjectAddress, value);
    }

    @Override
    public void writeCommand(ASDUHeader header, InformationObjectAddress informationObjectAddress, boolean state, byte type, MirrorCommand mirrorCommand, boolean execute) {
        this.scheduleCommand(new WriteModel.Request<Boolean>(header, informationObjectAddress, state, type, execute), mirrorCommand, WriteModel::prepareCommand);
    }

    @Override
    public void writeFloatValue(ASDUHeader header, InformationObjectAddress informationObjectAddress, float value, byte type, MirrorCommand mirrorCommand, boolean execute) {
        this.scheduleCommand(new WriteModel.Request<Float>(header, informationObjectAddress, Float.valueOf(value), type, execute), mirrorCommand, WriteModel::prepareSetpointFloat);
    }

    @Override
    public void writeScaledValue(ASDUHeader header, InformationObjectAddress informationObjectAddress, short value, byte type, MirrorCommand mirrorCommand, boolean execute) {
        this.scheduleCommand(new WriteModel.Request<Short>(header, informationObjectAddress, value, type, execute), mirrorCommand, WriteModel::prepareSetpointScaled);
    }

    private synchronized <T> void scheduleCommand(WriteModel.Request<T> request, MirrorCommand mirrorCommand, BiFunction<WriteModel, WriteModel.Request<T>, WriteModel.Action> func) {
        WriteModel writeModel = this.writeModel;
        this.executor.execute(() -> {
            WriteModel.Action action = (WriteModel.Action)func.apply(writeModel, request);
            if (action == null) {
                mirrorCommand.sendActivationConfirm(false);
                return;
            }
            mirrorCommand.sendActivationConfirm(true);
            action.execute().whenComplete((v, e) -> {
                logger.debug("Write command completed - request: {}", (Object)request);
                mirrorCommand.sendActivationTermination();
            });
        });
    }

    @Override
    public ListenableFuture<Value<?>> read(ASDUAddress asduAddress, InformationObjectAddress address) {
        return this.executor.submit(() -> this.performRead(asduAddress, address));
    }

    protected synchronized Value<?> performRead(ASDUAddress asduAddress, InformationObjectAddress address) {
        Map map = (Map)this.cache.get(asduAddress.getAddress());
        if (map == null) {
            return null;
        }
        return (Value)map.get(address.getAddress());
    }

    @Override
    public synchronized ListenableFuture<Void> readAll(ASDUAddress asduAddress, Runnable prepare, DataListener listener) {
        Map map = (Map)this.cache.get(asduAddress.getAddress());
        if (map == null) {
            return null;
        }
        HashMap map2 = new HashMap(map);
        this.executor.submit(prepare);
        return this.executor.submit(() -> this.performReadAll(asduAddress, listener, map2), (Object)null);
    }

    protected synchronized void performReadAll(ASDUAddress asduAddress, DataListener listener, Map<Integer, Value<?>> map) {
        for (Map.Entry<Integer, Value<?>> entry : map.entrySet()) {
            ChangeDataModel.fireListener(asduAddress, listener, entry);
        }
    }

    private static void fireListener(ASDUAddress asduAddress, DataListener listener, Map.Entry<Integer, Value<?>> entry) {
        Value<?> ve = entry.getValue();
        Object v = ve.getValue();
        if (v instanceof Boolean) {
            listener.dataChangeBoolean(asduAddress, InformationObjectAddress.valueOf(entry.getKey()), Collections.singletonList(ve));
        } else if (v instanceof Float) {
            listener.dataChangeFloat(asduAddress, InformationObjectAddress.valueOf(entry.getKey()), Collections.singletonList(ve));
        }
    }

    @Override
    public void forAllAsdu(Consumer<ASDUAddress> function, Runnable ifNoneFound) {
        this.executor.execute(() -> this.performForAllAsdu(function, ifNoneFound));
    }

    protected synchronized void performForAllAsdu(Consumer<ASDUAddress> function, Runnable ifNoneFound) {
        if (this.cache.isEmpty()) {
            this.executor.execute(ifNoneFound);
            return;
        }
        for (Integer asdu : this.cache.keySet()) {
            this.executor.execute(() -> function.accept(ASDUAddress.valueOf(asdu)));
        }
    }
}

