/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.idgen;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.ignite.idgen.IgniteIdGenEndpoint;
import org.apache.camel.component.ignite.idgen.IgniteIdGenOperation;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.ignite.IgniteAtomicSequence;

public class IgniteIdGenProducer
extends DefaultAsyncProducer {
    private IgniteIdGenEndpoint endpoint;
    private IgniteAtomicSequence atomicSeq;

    public IgniteIdGenProducer(IgniteIdGenEndpoint endpoint, IgniteAtomicSequence atomicSeq) {
        super(endpoint);
        this.endpoint = endpoint;
        this.atomicSeq = atomicSeq;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Message in = exchange.getIn();
        Message out = exchange.getOut();
        MessageHelper.copyHeaders(in, out, true);
        Long id = in.getBody(Long.class);
        switch (this.idGenOperationFor(exchange)) {
            case ADD_AND_GET: {
                out.setBody(this.atomicSeq.addAndGet(id));
                break;
            }
            case GET: {
                out.setBody(this.atomicSeq.get());
                break;
            }
            case GET_AND_ADD: {
                out.setBody(this.atomicSeq.getAndAdd(id));
                break;
            }
            case GET_AND_INCREMENT: {
                out.setBody(this.atomicSeq.getAndIncrement());
                break;
            }
            case INCREMENT_AND_GET: {
                out.setBody(this.atomicSeq.incrementAndGet());
                break;
            }
            default: {
                exchange.setException(new UnsupportedOperationException("Operation not supported by Ignite ID Generator producer."));
            }
        }
        callback.done(false);
        return false;
    }

    private IgniteIdGenOperation idGenOperationFor(Exchange exchange) {
        return exchange.getIn().getHeader("CamelIgniteIdGenOperation", (Object)this.endpoint.getOperation(), IgniteIdGenOperation.class);
    }
}

