/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.messaging;

import java.util.Collection;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.ignite.IgniteHelper;
import org.apache.camel.component.ignite.messaging.IgniteMessagingEndpoint;
import org.apache.camel.component.ignite.messaging.IgniteMessagingSendMode;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteMessaging;

public class IgniteMessagingProducer
extends DefaultAsyncProducer {
    private IgniteMessagingEndpoint endpoint;
    private IgniteMessaging messaging;

    public IgniteMessagingProducer(IgniteMessagingEndpoint endpoint, Ignite ignite, IgniteMessaging messaging) {
        super(endpoint);
        this.endpoint = endpoint;
        this.messaging = messaging;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Message in = exchange.getIn();
        Message out = exchange.getOut();
        MessageHelper.copyHeaders(exchange.getIn(), out, true);
        Object body = in.getBody();
        if (this.endpoint.getSendMode() == IgniteMessagingSendMode.UNORDERED) {
            if (body instanceof Collection && !this.endpoint.isTreatCollectionsAsCacheObjects()) {
                this.messaging.send((Object)this.topicFor(exchange), (Collection)body);
            } else {
                this.messaging.send((Object)this.topicFor(exchange), body);
            }
        } else {
            this.messaging.sendOrdered(this.topicFor(exchange), body, this.endpoint.getTimeout());
        }
        IgniteHelper.maybePropagateIncomingBody(this.endpoint, in, out);
        callback.done(false);
        return false;
    }

    private String topicFor(Exchange exchange) {
        return exchange.getIn().getHeader("CamelIgniteMessagingTopic", this.endpoint.getTopic(), String.class);
    }
}

