/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.ignite.queue.IgniteQueueEndpoint;
import org.apache.camel.component.ignite.queue.IgniteQueueOperation;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.ignite.IgniteQueue;

public class IgniteQueueProducer
extends DefaultAsyncProducer {
    private IgniteQueueEndpoint endpoint;
    private IgniteQueue<Object> queue;

    public IgniteQueueProducer(IgniteQueueEndpoint endpoint, IgniteQueue<Object> queue) {
        super(endpoint);
        this.endpoint = endpoint;
        this.queue = queue;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Message in = exchange.getIn();
        Message out = exchange.getOut();
        MessageHelper.copyHeaders(exchange.getIn(), out, true);
        Object body = in.getBody();
        switch (this.queueOperationFor(exchange)) {
            case ADD: {
                if (Collection.class.isAssignableFrom(body.getClass()) && !this.endpoint.isTreatCollectionsAsCacheObjects()) {
                    out.setBody(this.queue.addAll((Collection)body));
                    break;
                }
                out.setBody(this.queue.add(body));
                break;
            }
            case CONTAINS: {
                if (Collection.class.isAssignableFrom(body.getClass()) && !this.endpoint.isTreatCollectionsAsCacheObjects()) {
                    out.setBody(this.queue.containsAll((Collection)body));
                    break;
                }
                out.setBody(this.queue.contains(body));
                break;
            }
            case SIZE: {
                out.setBody(this.queue.size());
                break;
            }
            case REMOVE: {
                if (Collection.class.isAssignableFrom(body.getClass()) && !this.endpoint.isTreatCollectionsAsCacheObjects()) {
                    out.setBody(this.queue.removeAll((Collection)body));
                    break;
                }
                out.setBody(this.queue.remove(body));
                break;
            }
            case CLEAR: {
                if (this.endpoint.isPropagateIncomingBodyIfNoReturnValue()) {
                    out.setBody(body);
                }
                this.queue.clear();
                break;
            }
            case ITERATOR: {
                Iterator<Object> iterator = this.queue.iterator();
                out.setBody(iterator);
                break;
            }
            case ARRAY: {
                out.setBody(this.queue.toArray());
                break;
            }
            case RETAIN_ALL: {
                if (Collection.class.isAssignableFrom(body.getClass())) {
                    out.setBody(this.queue.retainAll((Collection)body));
                    break;
                }
                out.setBody(this.queue.retainAll(Collections.singleton(body)));
                break;
            }
            case DRAIN: {
                Integer maxElements = in.getHeader("CamelIgniteQueueMaxElements", Integer.class);
                Collection col = null;
                col = body != null && Collection.class.isAssignableFrom(body.getClass()) ? (Collection)body : (maxElements != null ? new ArrayList(maxElements) : new ArrayList());
                int transferred = -1;
                transferred = maxElements == null ? this.queue.drainTo(col) : this.queue.drainTo(col, maxElements);
                out.setBody(col);
                out.setHeader("CamelIgniteQueueTransferredCount", transferred);
                break;
            }
            case ELEMENT: {
                out.setBody(this.queue.element());
                break;
            }
            case OFFER: {
                Long millis = in.getHeader("CamelIgniteQueueTimeoutMillis", this.endpoint.getTimeoutMillis(), Long.class);
                boolean result = millis == null ? this.queue.offer(body) : this.queue.offer(body, (long)millis, TimeUnit.MILLISECONDS);
                out.setBody(result);
                break;
            }
            case PEEK: {
                out.setBody(this.queue.peek());
                break;
            }
            case POLL: {
                Long millis = in.getHeader("CamelIgniteQueueTimeoutMillis", this.endpoint.getTimeoutMillis(), Long.class);
                out.setBody(millis == null ? this.queue.poll() : this.queue.poll(millis, TimeUnit.MILLISECONDS));
                break;
            }
            case PUT: {
                if (this.endpoint.isPropagateIncomingBodyIfNoReturnValue()) {
                    out.setBody(in.getBody());
                }
                this.queue.put(body);
                break;
            }
            case TAKE: {
                out.setBody(this.queue.take());
                break;
            }
            default: {
                exchange.setException(new UnsupportedOperationException("Operation not supported by Ignite Queue producer."));
            }
        }
        callback.done(false);
        return false;
    }

    private IgniteQueueOperation queueOperationFor(Exchange exchange) {
        return exchange.getIn().getHeader("CamelIgniteQueueOperation", (Object)this.endpoint.getOperation(), IgniteQueueOperation.class);
    }
}

