/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.streams;

import org.apache.ignite.internal.binary.streams.BinaryAbstractInputStream;
import org.apache.ignite.internal.util.GridUnsafe;

public class BinaryOffheapInputStream
extends BinaryAbstractInputStream {
    private final long ptr;
    private final int cap;
    private boolean forceHeap;

    public BinaryOffheapInputStream(long ptr, int cap) {
        this(ptr, cap, false);
    }

    public BinaryOffheapInputStream(long ptr, int cap, boolean forceHeap) {
        this.ptr = ptr;
        this.cap = cap;
        this.forceHeap = forceHeap;
        this.len = cap;
    }

    @Override
    public int remaining() {
        return this.cap - this.pos;
    }

    @Override
    public int capacity() {
        return this.cap;
    }

    @Override
    public byte[] array() {
        return this.arrayCopy();
    }

    @Override
    public byte[] arrayCopy() {
        byte[] res = new byte[this.len];
        GridUnsafe.copyOffheapHeap(this.ptr, res, GridUnsafe.BYTE_ARR_OFF, res.length);
        return res;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    protected byte readByteAndShift() {
        return GridUnsafe.getByte(this.ptr + (long)this.pos++);
    }

    @Override
    protected void copyAndShift(Object target, long off, int len) {
        GridUnsafe.copyOffheapHeap(this.ptr + (long)this.pos, target, off, len);
        this.shift(len);
    }

    @Override
    protected short readShortFast() {
        long addr = this.ptr + (long)this.pos;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getShortLE(addr) : GridUnsafe.getShort(addr);
    }

    @Override
    protected char readCharFast() {
        long addr = this.ptr + (long)this.pos;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getCharLE(addr) : GridUnsafe.getChar(addr);
    }

    @Override
    protected int readIntFast() {
        long addr = this.ptr + (long)this.pos;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getIntLE(addr) : GridUnsafe.getInt(addr);
    }

    @Override
    protected long readLongFast() {
        long addr = this.ptr + (long)this.pos;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getLongLE(addr) : GridUnsafe.getLong(addr);
    }

    @Override
    protected byte readBytePositioned0(int pos) {
        return GridUnsafe.getByte(this.ptr + (long)pos);
    }

    @Override
    protected short readShortPositioned0(int pos) {
        long addr = this.ptr + (long)pos;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getShortLE(addr) : GridUnsafe.getShort(addr);
    }

    @Override
    protected int readIntPositioned0(int pos) {
        long addr = this.ptr + (long)pos;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getIntLE(addr) : GridUnsafe.getInt(addr);
    }

    @Override
    public long offheapPointer() {
        return this.forceHeap ? 0L : this.ptr;
    }

    @Override
    public long rawOffheapPointer() {
        return this.ptr;
    }
}

