/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.resource.GridResourceIoc;
import org.apache.ignite.internal.processors.resource.GridResourceProcessor;
import org.jetbrains.annotations.Nullable;

public class EntryProcessorResourceInjectorProxy<K, V, T>
implements EntryProcessor<K, V, T>,
Serializable {
    private static final long serialVersionUID = 0L;
    private EntryProcessor<K, V, T> delegate;
    private transient boolean injected;

    private EntryProcessorResourceInjectorProxy(EntryProcessor<K, V, T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T process(MutableEntry<K, V> entry, Object ... arguments) throws EntryProcessorException {
        if (!this.injected) {
            GridCacheContext cctx = entry.unwrap(GridCacheContext.class);
            GridResourceProcessor rsrc = cctx.kernalContext().resource();
            try {
                rsrc.inject(this.delegate, GridResourceIoc.AnnotationSet.ENTRY_PROCESSOR, cctx.name());
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            this.injected = true;
        }
        return this.delegate.process(entry, arguments);
    }

    public EntryProcessor<K, V, T> delegate() {
        return this.delegate;
    }

    public static <K, V, T> EntryProcessor<K, V, T> wrap(GridKernalContext ctx, @Nullable EntryProcessor<K, V, T> proc) {
        if (proc == null || proc instanceof EntryProcessorResourceInjectorProxy) {
            return proc;
        }
        GridResourceProcessor rsrcProc = ctx.resource();
        return rsrcProc.isAnnotationsPresent(null, proc, GridResourceIoc.AnnotationSet.ENTRY_PROCESSOR) ? new EntryProcessorResourceInjectorProxy<K, V, T>(proc) : proc;
    }

    static Object unwrap(Object obj) {
        return obj instanceof EntryProcessorResourceInjectorProxy ? ((EntryProcessorResourceInjectorProxy)obj).delegate() : obj;
    }
}

