/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.Collection;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cdc.CdcCacheEvent;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.processors.cache.CacheConfigurationEnrichment;
import org.apache.ignite.internal.processors.cache.CacheConfigurationSplitter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;

public class StoredCacheData
implements Serializable,
CdcCacheEvent {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private CacheConfiguration<?, ?> ccfg;
    @GridToStringInclude
    private Collection<QueryEntity> qryEntities;
    private boolean sql;
    private CacheConfigurationEnrichment cacheConfigurationEnrichment;
    private GroupKeyEncrypted grpKeyEncrypted;

    public StoredCacheData(CacheConfiguration<?, ?> ccfg) {
        A.notNull(ccfg, "ccfg");
        this.ccfg = ccfg;
        this.qryEntities = ccfg.getQueryEntities();
    }

    public StoredCacheData(StoredCacheData cacheData) {
        this.ccfg = cacheData.ccfg;
        this.qryEntities = cacheData.qryEntities;
        this.sql = cacheData.sql;
        this.cacheConfigurationEnrichment = cacheData.cacheConfigurationEnrichment;
        this.grpKeyEncrypted = cacheData.grpKeyEncrypted;
    }

    public void config(CacheConfiguration<?, ?> ccfg) {
        this.ccfg = ccfg;
    }

    public CacheConfiguration<?, ?> config() {
        return this.ccfg;
    }

    @Override
    public Collection<QueryEntity> queryEntities() {
        return this.qryEntities;
    }

    public void queryEntities(Collection<QueryEntity> qryEntities) {
        this.qryEntities = qryEntities;
    }

    public boolean sql() {
        return this.sql;
    }

    public StoredCacheData sql(boolean sql) {
        this.sql = sql;
        return this;
    }

    public GroupKeyEncrypted groupKeyEncrypted() {
        return this.grpKeyEncrypted;
    }

    public void groupKeyEncrypted(GroupKeyEncrypted grpKeyEncrypted) {
        this.grpKeyEncrypted = grpKeyEncrypted;
    }

    public StoredCacheData cacheConfigurationEnrichment(CacheConfigurationEnrichment ccfgEnrichment) {
        this.cacheConfigurationEnrichment = ccfgEnrichment;
        return this;
    }

    public CacheConfigurationEnrichment cacheConfigurationEnrichment() {
        return this.cacheConfigurationEnrichment;
    }

    public boolean hasOldCacheConfigurationFormat() {
        return this.cacheConfigurationEnrichment == null;
    }

    public StoredCacheData withSplittedCacheConfig(CacheConfigurationSplitter splitter) {
        if (this.cacheConfigurationEnrichment != null) {
            return this;
        }
        T2<CacheConfiguration, CacheConfigurationEnrichment> splitCfg = splitter.split(this.ccfg);
        this.ccfg = (CacheConfiguration)splitCfg.get1();
        this.cacheConfigurationEnrichment = (CacheConfigurationEnrichment)splitCfg.get2();
        return this;
    }

    public String toString() {
        return S.toString(StoredCacheData.class, this);
    }

    @Override
    public int cacheId() {
        return CU.cacheId(this.ccfg.getName());
    }

    @Override
    public CacheConfiguration<?, ?> configuration() {
        return this.ccfg;
    }
}

