/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.CamelContext;
import org.apache.camel.component.infinispan.InfinispanOperation;
import org.apache.camel.component.infinispan.InfinispanQueryBuilder;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteComponent;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteCustomListener;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;

public class InfinispanRemoteComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private InfinispanRemoteConfiguration getOrCreateConfiguration(InfinispanRemoteComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new InfinispanRemoteConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        InfinispanRemoteComponent target = (InfinispanRemoteComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(InfinispanRemoteComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(InfinispanRemoteComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "cachecontainer": 
            case "cacheContainer": {
                this.getOrCreateConfiguration(target).setCacheContainer(InfinispanRemoteComponentConfigurer.property(camelContext, RemoteCacheManager.class, value));
                return true;
            }
            case "cachecontainerconfiguration": 
            case "cacheContainerConfiguration": {
                this.getOrCreateConfiguration(target).setCacheContainerConfiguration(InfinispanRemoteComponentConfigurer.property(camelContext, Configuration.class, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(InfinispanRemoteComponentConfigurer.property(camelContext, InfinispanRemoteConfiguration.class, value));
                return true;
            }
            case "configurationproperties": 
            case "configurationProperties": {
                this.getOrCreateConfiguration(target).setConfigurationProperties(InfinispanRemoteComponentConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "configurationuri": 
            case "configurationUri": {
                this.getOrCreateConfiguration(target).setConfigurationUri(InfinispanRemoteComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "customlistener": 
            case "customListener": {
                this.getOrCreateConfiguration(target).setCustomListener(InfinispanRemoteComponentConfigurer.property(camelContext, InfinispanRemoteCustomListener.class, value));
                return true;
            }
            case "defaultvalue": 
            case "defaultValue": {
                this.getOrCreateConfiguration(target).setDefaultValue(InfinispanRemoteComponentConfigurer.property(camelContext, Object.class, value));
                return true;
            }
            case "eventtypes": 
            case "eventTypes": {
                this.getOrCreateConfiguration(target).setEventTypes(InfinispanRemoteComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "flags": {
                this.getOrCreateConfiguration(target).setFlags(InfinispanRemoteComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "hosts": {
                this.getOrCreateConfiguration(target).setHosts(InfinispanRemoteComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "key": {
                this.getOrCreateConfiguration(target).setKey(InfinispanRemoteComponentConfigurer.property(camelContext, Object.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(InfinispanRemoteComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "oldvalue": 
            case "oldValue": {
                this.getOrCreateConfiguration(target).setOldValue(InfinispanRemoteComponentConfigurer.property(camelContext, Object.class, value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation(InfinispanRemoteComponentConfigurer.property(camelContext, InfinispanOperation.class, value));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword(InfinispanRemoteComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "querybuilder": 
            case "queryBuilder": {
                this.getOrCreateConfiguration(target).setQueryBuilder(InfinispanRemoteComponentConfigurer.property(camelContext, InfinispanQueryBuilder.class, value));
                return true;
            }
            case "remappingfunction": 
            case "remappingFunction": {
                this.getOrCreateConfiguration(target).setRemappingFunction(InfinispanRemoteComponentConfigurer.property(camelContext, BiFunction.class, value));
                return true;
            }
            case "resultheader": 
            case "resultHeader": {
                this.getOrCreateConfiguration(target).setResultHeader(InfinispanRemoteComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "saslmechanism": 
            case "saslMechanism": {
                this.getOrCreateConfiguration(target).setSaslMechanism(InfinispanRemoteComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "secure": {
                this.getOrCreateConfiguration(target).setSecure(InfinispanRemoteComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "securityrealm": 
            case "securityRealm": {
                this.getOrCreateConfiguration(target).setSecurityRealm(InfinispanRemoteComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "securityservername": 
            case "securityServerName": {
                this.getOrCreateConfiguration(target).setSecurityServerName(InfinispanRemoteComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "username": {
                this.getOrCreateConfiguration(target).setUsername(InfinispanRemoteComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "value": {
                this.getOrCreateConfiguration(target).setValue(InfinispanRemoteComponentConfigurer.property(camelContext, Object.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getAutowiredNames() {
        return new String[]{"cacheContainer", "cacheContainerConfiguration"};
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "cachecontainer": 
            case "cacheContainer": {
                return RemoteCacheManager.class;
            }
            case "cachecontainerconfiguration": 
            case "cacheContainerConfiguration": {
                return Configuration.class;
            }
            case "configuration": {
                return InfinispanRemoteConfiguration.class;
            }
            case "configurationproperties": 
            case "configurationProperties": {
                return Map.class;
            }
            case "configurationuri": 
            case "configurationUri": {
                return String.class;
            }
            case "customlistener": 
            case "customListener": {
                return InfinispanRemoteCustomListener.class;
            }
            case "defaultvalue": 
            case "defaultValue": {
                return Object.class;
            }
            case "eventtypes": 
            case "eventTypes": {
                return String.class;
            }
            case "flags": {
                return String.class;
            }
            case "hosts": {
                return String.class;
            }
            case "key": {
                return Object.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "oldvalue": 
            case "oldValue": {
                return Object.class;
            }
            case "operation": {
                return InfinispanOperation.class;
            }
            case "password": {
                return String.class;
            }
            case "querybuilder": 
            case "queryBuilder": {
                return InfinispanQueryBuilder.class;
            }
            case "remappingfunction": 
            case "remappingFunction": {
                return BiFunction.class;
            }
            case "resultheader": 
            case "resultHeader": {
                return String.class;
            }
            case "saslmechanism": 
            case "saslMechanism": {
                return String.class;
            }
            case "secure": {
                return Boolean.TYPE;
            }
            case "securityrealm": 
            case "securityRealm": {
                return String.class;
            }
            case "securityservername": 
            case "securityServerName": {
                return String.class;
            }
            case "username": {
                return String.class;
            }
            case "value": {
                return Object.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        InfinispanRemoteComponent target = (InfinispanRemoteComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "cachecontainer": 
            case "cacheContainer": {
                return this.getOrCreateConfiguration(target).getCacheContainer();
            }
            case "cachecontainerconfiguration": 
            case "cacheContainerConfiguration": {
                return this.getOrCreateConfiguration(target).getCacheContainerConfiguration();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "configurationproperties": 
            case "configurationProperties": {
                return this.getOrCreateConfiguration(target).getConfigurationProperties();
            }
            case "configurationuri": 
            case "configurationUri": {
                return this.getOrCreateConfiguration(target).getConfigurationUri();
            }
            case "customlistener": 
            case "customListener": {
                return this.getOrCreateConfiguration(target).getCustomListener();
            }
            case "defaultvalue": 
            case "defaultValue": {
                return this.getOrCreateConfiguration(target).getDefaultValue();
            }
            case "eventtypes": 
            case "eventTypes": {
                return this.getOrCreateConfiguration(target).getEventTypes();
            }
            case "flags": {
                return this.getOrCreateConfiguration(target).getFlags();
            }
            case "hosts": {
                return this.getOrCreateConfiguration(target).getHosts();
            }
            case "key": {
                return this.getOrCreateConfiguration(target).getKey();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "oldvalue": 
            case "oldValue": {
                return this.getOrCreateConfiguration(target).getOldValue();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "querybuilder": 
            case "queryBuilder": {
                return this.getOrCreateConfiguration(target).getQueryBuilder();
            }
            case "remappingfunction": 
            case "remappingFunction": {
                return this.getOrCreateConfiguration(target).getRemappingFunction();
            }
            case "resultheader": 
            case "resultHeader": {
                return this.getOrCreateConfiguration(target).getResultHeader();
            }
            case "saslmechanism": 
            case "saslMechanism": {
                return this.getOrCreateConfiguration(target).getSaslMechanism();
            }
            case "secure": {
                return this.getOrCreateConfiguration(target).isSecure();
            }
            case "securityrealm": 
            case "securityRealm": {
                return this.getOrCreateConfiguration(target).getSecurityRealm();
            }
            case "securityservername": 
            case "securityServerName": {
                return this.getOrCreateConfiguration(target).getSecurityServerName();
            }
            case "username": {
                return this.getOrCreateConfiguration(target).getUsername();
            }
            case "value": {
                return this.getOrCreateConfiguration(target).getValue();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "configurationproperties": 
            case "configurationProperties": {
                return String.class;
            }
        }
        return null;
    }
}

