/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.ValidationException;
import org.apache.camel.processor.transformer.TypeConverterTransformer;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.Contract;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeAware;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractAdvice
implements CamelInternalProcessorAdvice<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(ContractAdvice.class);
    private final Contract contract;

    public ContractAdvice(Contract contract) {
        this.contract = contract;
    }

    @Override
    public Object before(Exchange exchange) throws Exception {
        if (!(exchange.getIn() instanceof DataTypeAware)) {
            return null;
        }
        try {
            DataType to = this.contract.getInputType();
            if (to != null) {
                DataTypeAware target = (DataTypeAware)((Object)exchange.getIn());
                DataType from = target.getDataType();
                if (!to.equals(from)) {
                    LOG.debug("Looking for transformer for INPUT: from='{}', to='{}'", (Object)from, (Object)to);
                    this.doTransform(exchange.getIn(), from, to);
                    target.setDataType(to);
                }
                if (this.contract.isValidateInput()) {
                    this.doValidate(exchange.getIn(), to);
                }
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        return null;
    }

    @Override
    public void after(Exchange exchange, Object data) throws Exception {
        if (exchange.isFailed()) {
            return;
        }
        Message target = exchange.getMessage();
        if (!(target instanceof DataTypeAware)) {
            return;
        }
        try {
            DataType to = this.contract.getOutputType();
            if (to != null) {
                DataTypeAware typeAwareTarget = (DataTypeAware)((Object)target);
                DataType from = typeAwareTarget.getDataType();
                if (!to.equals(from)) {
                    LOG.debug("Looking for transformer for OUTPUT: from='{}', to='{}'", (Object)from, (Object)to);
                    this.doTransform(target, from, to);
                    typeAwareTarget.setDataType(to);
                }
                if (this.contract.isValidateOutput()) {
                    this.doValidate(target, to);
                }
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
    }

    @Override
    public boolean hasState() {
        return false;
    }

    private void doTransform(Message message, DataType from, DataType to) throws Exception {
        if (from == null) {
            this.convertIfRequired(message, to);
            return;
        }
        this.convertIfRequired(message, from);
        if (this.applyMatchedTransformer(message, from, to)) {
            return;
        }
        if (from.isJavaType()) {
            this.convertIfRequired(message, to);
            return;
        }
        if (this.applyTransformerChain(message, from, to)) {
            return;
        }
        throw new IllegalArgumentException("No Transformer found for [from='" + String.valueOf(from) + "', to='" + String.valueOf(to) + "']");
    }

    private void convertIfRequired(Message message, DataType type) throws Exception {
        if (DataType.isAnyType(type) || !DataType.isJavaType(type) || type.getName() == null) {
            return;
        }
        CamelContext context = message.getExchange().getContext();
        Transformer transformer = context.resolveTransformer(DataType.ANY, type);
        if (transformer != null) {
            transformer.transform(message, DataType.ANY, type);
        } else {
            new TypeConverterTransformer(type).transform(message, DataType.ANY, type);
        }
    }

    private boolean applyMatchedTransformer(Message message, DataType from, DataType to) throws Exception {
        Transformer transformer = message.getExchange().getContext().resolveTransformer(from, to);
        if (transformer == null) {
            return false;
        }
        LOG.debug("Applying transformer: from='{}', to='{}', transformer='{}'", new Object[]{from, to, transformer});
        transformer.transform(message, from, to);
        return true;
    }

    private boolean applyTransformerChain(Message message, DataType from, DataType to) throws Exception {
        CamelContext context = message.getExchange().getContext();
        Transformer fromTransformer = context.resolveTransformer(DataType.ANY, from);
        Transformer toTransformer = context.resolveTransformer(DataType.ANY, to);
        if (fromTransformer != null && toTransformer != null) {
            LOG.debug("Applying transformer 1/2: from='{}', to='{}', transformer='{}'", new Object[]{from, to, fromTransformer});
            fromTransformer.transform(message, from, new DataType(Object.class));
            LOG.debug("Applying transformer 2/2: from='{}', to='{}', transformer='{}'", new Object[]{from, to, toTransformer});
            toTransformer.transform(message, new DataType(Object.class), to);
            return true;
        }
        return false;
    }

    private Class<?> getClazz(String type, CamelContext context) throws Exception {
        return context.getClassResolver().resolveMandatoryClass(type);
    }

    private void doValidate(Message message, DataType type) throws ValidationException {
        Validator validator = message.getExchange().getContext().resolveValidator(type);
        if (validator == null) {
            throw new ValidationException(message.getExchange(), String.format("No Validator found for '%s'", type));
        }
        LOG.debug("Applying validator: type='{}', validator='{}'", (Object)type, (Object)validator);
        validator.validate(message, type);
    }
}

