/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.VersionedMetadataImpl;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.ChannelInputStream;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

@Immutable
public class GetStreamOperation
extends AbstractKeyOperation<ChannelInputStream> {
    private final int offset;
    private Channel channel;

    public GetStreamOperation(Codec codec, ChannelFactory channelFactory, Object key, byte[] keyBytes, int offset, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, ClientStatistics clientStatistics) {
        super((short)55, (short)56, codec, channelFactory, key, keyBytes, cacheName, clientTopology, flags, cfg, null, clientStatistics, null);
        this.offset = offset;
    }

    @Override
    public void executeOperation(Channel channel) {
        this.channel = channel;
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateArraySize(this.keyBytes) + ByteBufUtil.estimateVIntSize(this.offset));
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.keyBytes);
        ByteBufUtil.writeVInt(buf, this.offset);
        channel.writeAndFlush(buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isNotExist(status) || !HotRodConstants.isSuccess(status)) {
            this.statsDataRead(false);
            this.complete(null);
        } else {
            int totalLength;
            long version;
            VersionedMetadataImpl versionedMetadata;
            ChannelInputStream stream;
            short flags = buf.readUnsignedByte();
            long creation = -1L;
            int lifespan = -1;
            long lastUsed = -1L;
            int maxIdle = -1;
            if ((flags & 1) != 1) {
                creation = buf.readLong();
                lifespan = ByteBufUtil.readVInt(buf);
            }
            if ((flags & 2) != 2) {
                lastUsed = buf.readLong();
                maxIdle = ByteBufUtil.readVInt(buf);
            }
            if ((stream = new ChannelInputStream(versionedMetadata = new VersionedMetadataImpl(creation, lifespan, lastUsed, maxIdle, version = buf.readLong()), () -> {
                if (this.channel.pipeline().get(ChannelInputStream.class) != null) {
                    this.channel.pipeline().remove(ChannelInputStream.class);
                }
            }, totalLength = ByteBufUtil.readVInt(buf))).moveReadable(buf)) {
                this.channel.pipeline().addBefore("header-decoder", "stream", stream);
            }
            this.statsDataRead(true);
            this.complete(stream);
        }
    }
}

