/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableZipIterable<T, U, V>
extends AbstractFlowableWithUpstream<T, V> {
    final Iterable<U> other;
    final BiFunction<? super T, ? super U, ? extends V> zipper;

    public FlowableZipIterable(Flowable<T> source, Iterable<U> other, BiFunction<? super T, ? super U, ? extends V> zipper) {
        super(source);
        this.other = other;
        this.zipper = zipper;
    }

    @Override
    public void subscribeActual(Subscriber<? super V> t) {
        boolean b;
        Iterator<U> it;
        try {
            it = Objects.requireNonNull(this.other.iterator(), "The iterator returned by other is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptySubscription.error(e, t);
            return;
        }
        try {
            b = it.hasNext();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptySubscription.error(e, t);
            return;
        }
        if (!b) {
            EmptySubscription.complete(t);
            return;
        }
        this.source.subscribe(new ZipIterableSubscriber<T, U, V>(t, it, this.zipper));
    }

    static final class ZipIterableSubscriber<T, U, V>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super V> downstream;
        final Iterator<U> iterator;
        final BiFunction<? super T, ? super U, ? extends V> zipper;
        Subscription upstream;
        boolean done;

        ZipIterableSubscriber(Subscriber<? super V> actual, Iterator<U> iterator, BiFunction<? super T, ? super U, ? extends V> zipper) {
            this.downstream = actual;
            this.iterator = iterator;
            this.zipper = zipper;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            boolean b;
            V v;
            U u;
            if (this.done) {
                return;
            }
            try {
                u = Objects.requireNonNull(this.iterator.next(), "The iterator returned a null value");
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            try {
                v = Objects.requireNonNull(this.zipper.apply(t, u), "The zipper function returned a null value");
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.downstream.onNext(v);
            try {
                b = this.iterator.hasNext();
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            if (!b) {
                this.done = true;
                this.upstream.cancel();
                this.downstream.onComplete();
            }
        }

        void fail(Throwable e) {
            Exceptions.throwIfFatal(e);
            this.done = true;
            this.upstream.cancel();
            this.downstream.onError(e);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }
    }
}

